$: << File.dirname(__FILE__)
require "connect"

require "rubygems"


class ActiveRecord::Base
  def self.encrypt(*attr_names)
    encrypter = Encrypter.new(attr_names)
    
    before_save encrypter
    after_save  encrypter
    after_find  encrypter

    define_method(:after_find) { }
  end
end

class Encrypter

  # Przekazujemy listę atrybutów,
  # które należy zapisać w bazie w postaci zaszyfrowanej
  def initialize(attrs_to_manage)
    @attrs_to_manage = attrs_to_manage
  end

  # Przed zapisem lub aktualizacją zaszyfruj tekst przy pomocy
  # supertajnego szyfru przesuwającego.
  def before_save(model)
    @attrs_to_manage.each do |field|
      model[field].tr!("a-z", "b-za")
    end
  end

  # Po zapisie ponownie odszyfruj tekst
  def after_save(model)
    @attrs_to_manage.each do |field|
      model[field].tr!("b-za", "a-z")
    end
  end

  # Zrób to samo po odnalezieniu istniejącego rekordu
  alias_method :after_find, :after_save
end

ActiveRecord::Schema.define do
  create_table "orders", :force => true do |t|
    t.column "name",     :string
    t.column "address",  :text
    t.column "email",    :string
    t.column "pay_type", :string, :limit => 10
  end
end

class Order < ActiveRecord::Base
  encrypt(:name, :email)
end

o = Order.new
o.name    = "Jan Kowalski"
o.address = "Ulica Prosta 123"
o.email   = "jan@domena.pl"
o.save
puts o.name

o = Order.find(o.id)
puts o.name
