# == Schema Information
# Schema version: 7
#
# Table name: products
#
#  id          :integer(11)   not null, primary key
#  title       :string(255)   
#  description :text          
#  image_url   :string(255)   
#  price       :decimal(8, 2) default(0.0)
#

class Product < ActiveRecord::Base
  has_many :orders, :through => :line_items
  has_many :line_items
  validates_presence_of :title, :description, :image_url
  validates_numericality_of :price
  validates_uniqueness_of :title
  validates_format_of :image_url,
                      :with => %r{\.(gif|jpg|png)$}i,
                      :message => "musi być adresem URL obrazka GIF, JPG lub PNG"

  def self.find_products_for_sale
    find(:all, :order => "title")
  end

  protected
  def validate
    errors.add(:price, "powinna wynosić przynajmniej 0.01" ) if price.nil? || price < 0.01
  end
end

