class LoginController < ApplicationController
  before_filter :authorize, :except => :login
  layout "admin"
  def add_user
    @user = User.new(params[:user])
    if request.post? and @user.save
      flash.now[:notice] = "Utworzono konto użytkownika #{@user.name}"
      @user = User.new
    end
  end

  def login
    session[:user_id] = nil
    if request.post?
      user = User.authenticate(params[:name], params[:password])
      if user
        session[:user_id] = user.id
        redirect_to(:action => "index")
      else
        flash[:notice] = "Nieprawidłowy login lub hasło"
      end
    end
  end

  def logout
    session[:user_id] = nil
    flash[:notice] = "Wylogowano pomyślnie"
    redirect_to(:action => "login")
  end

  def index
    @total_orders = Order.count
  end

  def delete_user
    if request.post?
      user = User.find(params[:id])
      begin
        user.destroy
        flash[:notice] = "Użytkownik #{user.name} został usunięty"
      rescue Exception => e
        flash[:notice] = e.message
      end
    end
    redirect_to(:action => :list_users)
  end

  def list_users
    @all_users = User.find(:all)
  end
end
