class StoreController < ApplicationController
  def index
    @products = Product.find_products_for_sale
    @cart = find_cart
  end

  def add_to_cart
    begin
      product = Product.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      logger.error("Próba dostępu do nieistniejącego produktu: #{params[:id]}")
      redirect_to_index("Nieprawidłowy produkt")
    else
      @cart = find_cart
      @current_item = @cart.add_product(product)
    end
  end

  def empty_cart
    session[:cart] = nil
    redirect_to_index("Twój koszyk jest pusty")
  end

  private
  def redirect_to_index(msg = nil)
    flash[:notice] = msg if msg
    redirect_to :action => :index
  end

  def find_cart
    session[:cart] ||= Cart.new
  end
end

