$: << "../_template/vendor/rails/activesupport/lib/active_support/vendor"

require 'builder/xmlmarkup'

class Product
  def initialize(title, price)
    @title = title
    @price = price
  end
  attr_reader :title, :price
end

@products = [
  Product.new("Pragmatyczny Programista", 39.95),
  Product.new("Programowanie w języku Ruby", 69.99)
]

xml = Builder::XmlMarkup.new(:indent => 2)

xml.div(:class => "productlist") do
  xml.timestamp(Time.now)
  @products.each do |product|
    xml.product do
      xml.productname(product.title)
      xml.price(product.price, :currency => "zł")
    end
  end
end

puts xml.target!

