class ProductsController < ApplicationController

  def new
    @product = Product.new
    @details = Detail.new
  end
  
  def create
    @product = Product.new(params[:product])
    @details = Detail.new(params[:details])

    Product.transaction do
      @details.product = @product
      @product.save!
      @details.save!
      redirect_to :action => :show, :id => @product
    end

  rescue ActiveRecord::RecordInvalid => e
    @details.valid?   # wymusza sprawdzanie błędów, nawet gdy nie powiodła się walidacja produktów
    render :action => :new
  end
  
  def show
    @product = Product.find(params[:id])
  end
end
