require File.dirname(__FILE__) + '/../test_helper'

class RoutingTest < Test::Unit::TestCase

  def test_recognizes
    
    # Sprawdź, czy generowana jest domyślna akcja index
    assert_recognizes({"controller" => "store", "action" => "index" }, "/store")

    # Sprawdź routing akcji
    assert_recognizes({"controller" => "store", "action" => "list" },
                       "/store/list")
    
    # Trasa z parametrem
    assert_recognizes({ "controller" => "store",
                        "action" => "add_to_cart",
                        "id" => "1" },
                        "/store/add_to_cart/1")
    
    # Trasa z parametrem
    assert_recognizes({ "controller" => "store",
                        "action" => "add_to_cart",
                        "id" => "1",
                        "name" => "adam" },
                        "/store/add_to_cart/1",
                      { "name" => "adam" }) # to samo, co ?name=adam na końcu adresu URL
    
    # Żądanie POST
    assert_recognizes({ "controller" => "store",
                        "action" => "add_to_cart",
                        "id" => "1" },
                      { :path => "/store/add_to_cart/1", :method => :post })
  end

  
  def test_generates
    assert_generates("/store", :controller => "store", :action => "index" )
    assert_generates("/store/list", :controller => "store", :action => "list" )
    assert_generates("/store/add_to_cart/1",
                     { :controller => "store", :action => "add_to_cart",
                       :id => "1", :name => "adam" },
                     { :name => "adam" })
  end
  
  def test_routing
    assert_routing("/store", :controller => "store", :action => "index")
    assert_routing("/store/list", :controller => "store", :action => "list")
    assert_routing("/store/add_to_cart/1",
                   :controller => "store", :action => "add_to_cart", :id => "1")
  end

  
  def test_alternate_routing
    assert_generates("/store", :controller => "store")
    
    with_routing do |set|
      set.draw do |map|
        map.connect "shop/:action/:id", :controller => "store"
      
      assert_generates("/shop", :controller => "store")
      assert_recognizes({:controller => "store", :action => "index"}, "/shop")
      end
    end
    
    assert_generates("/store", :controller => "store")
  end    
    
end

