ActionController::Routing::Routes.draw do |map|

  # Adres http://moja.aplikacja/blog/ wyświetla stronę indeksu
  map.index    "blog/",
               :controller   => "blog",
               :action       => "index"

  # Artykuły dla danego roku, roku/miesiąca lub roku/miesiąca/dnia
  map.date     "blog/:year/:month/:day",
               :controller   => "blog",
               :action       => "show_date",
               :requirements => { :year => /(19|20)\d\d/,
                                 :month => /[01]?\d/,
                                 :day   => /[0-3]?\d/},
               :day          => nil,
               :month        => nil

  # Artykuł o podanym identyfikatorze
  map.show     "blog/show/:id",
               :controller    => "blog",
               :action        => "show",
               :id            => /\d+/

  # Routing funkcji administracyjnych
  map.admin "blog/:controller/:action/:id"

  # Zbiorcza obsługa nieprawidłowych żądań
  map.catchall "*anything",
               :controller  => "blog",
               :action      => "unknown_request"
end

