require File.dirname(__FILE__) + '/../test_helper'

class OrderMailerTest < Test::Unit::TestCase
  FIXTURES_PATH = File.dirname(__FILE__) + '/../fixtures'
  CHARSET = "utf-8"

  include ActionMailer::Quoting

  def setup
    @order = Order.new(:name =>"Jan Kowalski", :email => "jan.kowalski@domena.com.pl")
  end

  def test_confirm
    response = OrderMailer.create_confirm(@order)
    assert_equal("Potwierdzenie zamówienia", response.subject)
    assert_equal("jan.kowalski@domena.com.pl", response.to[0])
    assert_match(/Jan Kowalski/, response.body)
  end


  def test_sent
    response =  OrderMailer.create_sent(@order)
    assert_equal("Zamówienie zostało nadane", response.subject)
    # . . .
  end

  private
    def read_fixture(action)
      IO.readlines("#{FIXTURES_PATH}/order_mailer/#{action}")
    end

    def encode(subject)
      quoted_printable(subject, CHARSET)
    end
end
