require File.dirname(__FILE__) + '/../test_helper'
require 'order_controller'

# Zgłoś ponownie błędy przechwycone w kontrolerze.

class OrderController; def rescue_action(e) raise e end; end

class OrderControllerTest < Test::Unit::TestCase
  fixtures :orders
  def setup
    @controller = OrderController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @emails     = ActionMailer::Base.deliveries
    @emails.clear
  end
  def test_confirm
    get(:confirm, :id => orders(:sample_order).id)
    assert_redirected_to(:action => :index)
    assert_equal(1, @emails.size)
    email = @emails.first
    assert_equal("Potwierdzenie zamówienia", email.subject)
    assert_equal("jan.kowalski@domena.com.pl", email.to[0])
    assert_match(/Jan Kowalski/, email.body)
  end
end

