class OrderMailer < ActionMailer::Base

  def confirm(order)
    @subject       = "Potwierdzenie zamówienia"
    @recipients    = order.email
    @from          = 'zamowienia@sklep.com.pl'
    @sent_on       = Time.now
    @body["order"] = order
  end

  def sent(order)
    @subject       = "Zamówienie zostało nadane"
    @recipients    = order.email
    @from          = 'zamowienia@sklep.com.pl'
    @sent_on = Time.now
    @body["order"] = order
  end

  def survey(order)
    @subject       = "Czekamy na Twoją opinię"
    @recipients    = order.email
    @from          = 'zamowienia@sklep.com.pl'
    @sent_on       = Time.now
    @body["order"] = order
  end

  def ship_with_images(order)
    @subject       = "Zamówienie zostało nadane"
    @recipients    = order.email
    @from          = 'zamowienia@sklep.com.pl'
    @sent_on       = Time.now
    @body["order"] = order
    part :content_type => "text/html",
         :body => render_message("sent", :order => order)
    order.line_items.each do |li|
      image = li.product.image_location
      content_type = case File.extname(image)
      when ".jpg", ".jpeg";   "image/jpeg"
      when ".png";            "image/png"
      when ".gif";            "image/gif"
      else;                   "application/octet-stream"
      end
      attachment :content_type => content_type,
                 :body         => File.read(File.join("public", image)),
                 :filename     => File.basename(image)
    end
  end

end
