class TestController < ApplicationController
  def create_order
    order = Order.find_by_name("Jan Kowalski")
    email = OrderMailer.create_confirm(order)
    render(:text => "<pre>" + email.encoded + "</pre>")
  end

  def ship_order
    order = Order.find_by_name("Jan Kowalski")
    email = OrderMailer.create_sent(order)
    email.set_content_type("text/html")
    OrderMailer.deliver(email)
    render(:text => "Dziękujemy!")
  end

  def survey
    order = Order.find_by_name("Jan Kowalski")
    email = OrderMailer.deliver_survey(order)
    render(:text => "Wiadomość została wysłana")
  end

  def ship_with_images
    order = Order.find_by_name("Jan Kowalski")
    email = OrderMailer.deliver_ship_with_images(order)
    render(:text => "Wiadomość została wysłana")
  end


end

