class BlogController < ApplicationController

  around_filter :time_an_action

  around_filter do |controller, action|
    started = Time.now
    action.call
    elapsed = Time.now - started
    controller.logger.info("Czas trwania akcji #{controller.action_name} to #{elapsed} sekund")
  end     
  class TimingFilter
    def filter(controller)
      started = Time.now
      yield
      elapsed = Time.now - started
      controller.logger.info("Czas trwania akcji #{controller.action_name} to #{elapsed} sekund")
    end
  end
  
  around_filter TimingFilter.new
  def index
    # ...
    render :text => "witaj"
  end
  
  def bye
    # ...
    render :text => "żegnaj"
  end
  
  private
  
  def time_an_action
    started = Time.now
    yield
    elapsed = Time.now - started
    logger.info("Czas trwania akcji #{action_name} to #{elapsed} sekund")
  end

end
