require File.dirname(__FILE__) + '/../test_helper'
require 'login_controller'

# Re-raise errors caught by the controller.
class LoginController; def rescue_action(e) raise e end; end

class LoginControllerTest < Test::Unit::TestCase
  fixtures :users
  def setup
    @controller = LoginController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
  end

  # Replace this with your real tests.
  def test_truth
    assert true
  end

  if false
    def test_index
      get :index
      assert_response :success
    end
  end

  def test_index_without_user
    get :index
    assert_redirected_to :action => "login"
    assert_equal "Proszę się zalogować", flash[:notice]
  end

  def test_index_with_user
    get :index, {}, { :user_id => users(:adam).id }
    assert_response :success
    assert_template "index"
  end

  def test_login
    adam = users(:adam)
    post :login, :name => adam.name, :password => 'tajne'
    assert_redirected_to :action => "index"
    assert_equal adam.id, session[:user_id]
  end

  def test_bad_password
    adam = users(:adam)
    post :login, :name => adam.name, :password => 'zle'
    assert_template "login"
    assert_equal "Nieprawidłowy login lub hasło", flash[:notice]
  end


end
