$: << File.dirname(__FILE__)
require "connect"
require "logger"

ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"

ActiveRecord::Schema.define do

  create_table :people, :force => true do |t|
    t.column :type, :string

    # wspólne atrybuty
    t.column :name, :string
    t.column :email, :string

    # atrybuty dla typu Customer
    t.column :balance, :decimal, :precision => 10, :scale => 2

    # atrybuty dla typu Employee
    t.column :reports_to, :integer
    t.column :dept, :integer

    # atrybuty dla typu Manager
    # - brak -
  end
  
end

class Person < ActiveRecord::Base
end

class Customer < Person
end

class Employee < Person
  belongs_to :boss, :class_name => "Employee", :foreign_key => :reports_to
end

class Manager < Employee
end

Customer.create(:name => 'Jan Kowalski', :email => "jan@kowalski.com",
                :balance => 78.29)

zofia = Manager.create(:name => 'Zofia Nowak', :email => "zosia@adres.pl",
                       :dept => 23)

Customer.create(:name => 'Stefan Wiśniewski', :email => "s@skrzynka.net",
                :balance => 12.45)

bogdan = Employee.new(:name => 'Bogdan Małecki', :email => "bogdan@adres.pl",
                      :dept => 23)

bogdan.boss = zofia
bogdan.save!

manager = Person.find_by_name("Zofia Nowak")
puts manager.class    #=> Manager
puts manager.email    #=> zosia@adres.pl
puts manager.dept     #=> 23

customer = Person.find_by_name("Stefan Wiśniewski")
puts customer.class   #=> Customer
puts customer.email   #=> s@skrzynka.net
puts customer.balance #=> 12.45

