require "rubygems"

require 'connect'

ActiveRecord::Base.logger = Logger.new(STDOUT)


class Order < ActiveRecord::Base
end

class Payment < ActiveRecord::Base
end

class Refund < ActiveRecord::Base
end

class OrderObserver < ActiveRecord::Observer
  def after_save(an_order)
    an_order.logger.info("Utworzono zamówienie #{an_order.id}")
  end
end

OrderObserver.instance

class AuditObserver < ActiveRecord::Observer

  observe Order, Payment, Refund

  def after_save(model)
    model.logger.info("Utworzono obiekt #{model.id} klasy #{model.class.name}")
  end
end

AuditObserver.instance


o = Order.create
p = Payment.create

