$: << File.dirname(__FILE__)
require "connect"
require "logger"
require "rubygems"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

ActiveRecord::Schema.define do

  create_table :categories, :force => true do |t|
    t.column :name, :string
    t.column :parent_id, :integer
  end
end


class Category < ActiveRecord::Base
  acts_as_tree  :order => "name"
end


root        = Category.create(:name => "Książki")
fiction     = root.children.create(:name => "Fikcja")
non_fiction = root.children.create(:name => "Non fiction")

non_fiction.children.create(:name => "Komputery")
non_fiction.children.create(:name => "Nauka")
non_fiction.children.create(:name => "Historia sztuki")

fiction.children.create(:name => "Groza")
fiction.children.create(:name => "Romanse")
fiction.children.create(:name => "Science fiction")


def display_children(order)
  puts order.children.map {|child| child.name }.join(", ")
end

display_children(root)          # Fikcja, Non fiction

sub_category = root.children.first
puts sub_category.children.size #=> 3
display_children(sub_category)  #=> Groza, Romanse, Science fiction

non_fiction = root.children.find(:first, :conditions => "name = 'Non fiction'")

display_children(non_fiction)   #=> Historia sztuki, Komputery, Nauka
puts non_fiction.parent.name    #=> Książki

