require "#{File.dirname(__FILE__)}/../test_helper"
class UserStoriesTest < ActionController::IntegrationTest
  fixtures :products
  # Użytkownik wchodzi na główną stronę sklepu. Wybiera produkt
  # i dodaje do swojego koszyka. Potem przechodzi do kasy i podaje
  # swoje dane w formularzu zamówienia. Po wysłaniu formularza
  # w bazie danych tworzone jest zamówienie. Zawiera ono dane klienta
  # oraz jedną pozycję, która odpowiada produktowi dodanemu do koszyka.
  def test_buying_a_product  
    LineItem.delete_all
    Order.delete_all
    ruby_book = products(:ruby_book)
    get "/store/index"
    assert_response :success
    assert_template "index"
    xml_http_request "/store/add_to_cart", :id => ruby_book.id
    assert_response :success
    cart = session[:cart]
    assert_equal 1, cart.items.size
    assert_equal ruby_book, cart.items[0].product
    post "/store/checkout"
    assert_response :success
    assert_template "checkout"
    post_via_redirect "/store/save_order",
                      :order => { :name => "Adam Kowalski",
                      :address          => "Ul. Główna 123",
                      :email            => "klient@skladnica.pl",
                      :pay_type         => "check" }
    assert_response :success
    assert_template "index"
    assert_equal 0, session[:cart].items.size
    orders = Order.find(:all)
    assert_equal 1, orders.size
    order = orders[0]
    assert_equal "Adam Kowalski", order.name
    assert_equal "Ul. Główna 123", order.address
    assert_equal "klient@skladnica.pl", order.email
    assert_equal "check", order.pay_type
    assert_equal 1, order.line_items.size
    line_item = order.line_items[0]
    assert_equal ruby_book, line_item.product
  end
end

