# == Schema Information
# Schema version: 7
#
# Table name: orders
#
#  id       :integer(11)   not null, primary key
#  name     :string(255)   
#  address  :text          
#  email    :string(255)   
#  pay_type :string(10)    
#

class Order < ActiveRecord::Base
  has_many :line_items

  PAYMENT_TYPES = [
    # Wyświetlane         przechowywane w bazie danych
    [ "Czek",             "check" ],
    [ "Karta kredytowa",  "cc" ],
    [ "Zlecenie zakupu",  "po" ]
  ]
  validates_presence_of :name, :address, :email, :pay_type
  validates_inclusion_of :pay_type, :in => PAYMENT_TYPES.map {|disp, value| value}

  def add_line_items_from_cart(cart)
    cart.items.each do |item|
      li = LineItem.from_cart_item(item)
    line_items << li
    end
  end

end
