class StoreController < ApplicationController
  def index
    @products = Product.find_products_for_sale
  end

  def add_to_cart
    begin
      product = Product.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      logger.error("Próba dostępu do nieistniejącego produktu: #{params[:id]}")
      flash[:notice] = "Nieprawidłowy produkt"
      redirect_to :action => :index
    else
      @cart = find_cart
      @cart.add_product(product)
    end
  end

  def empty_cart
    session[:cart] = nil
    flash[:notice] = "Twój koszyk jest pusty"
    redirect_to :action => :index
  end

  private
  def find_cart
    session[:cart] ||= Cart.new
  end
end
