require File.dirname(__FILE__) + '/../test_helper'
require 'store_controller'
# Zgłoś ponownie błędy przechwycone przez kontroler
class StoreController; def rescue_action(e) raise e end; end
class OrderSpeedTest < Test::Unit::TestCase
  self.fixture_path = File.join(File.dirname(__FILE__), "../fixtures/performance")
  fixtures :products

  ADAMS_DETAILS = {
    :name       => "Adam Kowalski",
    :address    => "Ul. Główna 123",
    :email      => "klient@skladnica.pl",
    :pay_type   => "check"
  }

  def setup
    @controller = StoreController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
  end

  def test_100_orders
    Order.delete_all
    LineItem.delete_all
    @controller.logger.silence do
      elapsed_time = Benchmark.realtime do
        100.downto(1) do |prd_id|
          cart = Cart.new
          cart.add_product(Product.find(prd_id))
          post :save_order,
               { :order => ADAMS_DETAILS },
               { :cart => cart }
          assert_redirected_to :action => :index
        end
      end
      assert_equal 100, Order.count
      assert elapsed_time < 3.00
    end
  end

end

