﻿package {
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.net.FileReference;
  import flash.net.FileReferenceList;
  public class Files extends Sprite {
    private var _browse:TextField;
    private var _output:TextField;
    private var _fileReferenceList:FileReferenceList;
    public function Files() {
      _browse = new TextField();
      _browse.htmlText = "<u>Kliknij, aby przeglądać pliki</u>";
      _browse.addEventListener(MouseEvent.CLICK, clickHandler);
      addChild(_browse);
      _output = new TextField();
      _output.width = 400;
      _output.height = 400;
      _output.y = 50;
      addChild(_output);
      _fileReferenceList = new FileReferenceList();
      _fileReferenceList.addEventListener(Event.SELECT, selectHandler);
      _fileReferenceList.addEventListener(Event.CANCEL, cancelHandler);
    }
    private function clickHandler(event:MouseEvent):void {
      _fileReferenceList.browse();
    }
    private function selectHandler(event:Event):void {
      _output.text = "Wybrane pliki";
      var file:FileReference;
      for(var i:Number = 0; i < _fileReferenceList.fileList.length; i++) {
        file = _fileReferenceList.fileList[i];
        _output.appendText("\nNazwa: " + file.name);
        _output.appendText("\nRozmiar: " + file.size);
        _output.appendText("\nData utworzenia: " + file.creationDate);
        _output.appendText("\nData ostatniej modyfikacji: " + file.modificationDate);
        _output.appendText("\n----------------------------------");
      }
    }
    private function cancelHandler(event:Event):void {
      _output.text = "Anulowano";
    }
  }
}
