﻿package
{
	import flash.display.*;
	import flash.filters.BevelFilter;
	import flash.events.MouseEvent;

	public class BreakpointExample extends Sprite
	{
		protected var button:Sprite;
		
		public function BreakpointExample()
		{
			button = new Sprite();
			button.graphics.beginFill(0xaaaaaa);
			button.graphics.drawRoundRect(-50, -10, 100, 20, 6, 6);
			button.graphics.endFill();
			button.filters = [new BevelFilter(2)];
			button.buttonMode = true;
			button.x = stage.stageWidth / 2;
			button.y = stage.stageHeight / 2;
			addChild(button);
			
			button.addEventListener(MouseEvent.CLICK, onButtonClick);
		}
		
		protected function onButtonClick(event:MouseEvent):void
		{
			doSomethingTricky(event.localX, event.localY);
		}
		
		protected function doSomethingTricky(x:Number, y:Number):void
		{
			var distance:Number = Math.sqrt(x * x + y * y);
			trace("Dystans:", distance);
		}
	}
}
