﻿package pl.helion.as3biblia.printing {

	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.printing.PrintJob;
	import flash.geom.Rectangle;
	public class Printing extends Sprite {

		private var _printableContent:Sprite;
		private var _textField:TextField;
		private var _loader:URLLoader;

		public function Printing() {

			_loader = new URLLoader();
			_loader.load(new URLRequest("http://www.rightactionscript.com/samplefiles/lorem_ipsum.txt"));
			_loader.addEventListener(Event.COMPLETE, completeHandler);

			_textField = new TextField();
			_textField.width = 400;
			_textField.multiline = true;
			_textField.wordWrap = true;
			_textField.autoSize = TextFieldAutoSize.LEFT;

			_printableContent = new Sprite();
			addChild(_printableContent);
			_printableContent.addChild(_textField);

		}

		private function completeHandler(event:Event):void {  
			
			_textField.text = _loader.data;
			var printJob:PrintJob = new PrintJob();
			if(printJob.start()) {

				// Określ liczbę stron.
				var pages:Number = Math.ceil(_textField.height / printJob.pageHeight);
				_textField.width = printJob.pageWidth;

				// Przesuwaj się w pętli po wszystkich stronach.
				for(var i:Number = 0; i < pages; i++) {
					printJob.addPage(_printableContent, new Rectangle(0, i * printJob.pageHeight, printJob.pageWidth, printJob.pageHeight));
				}
				printJob.send();
				_textField.width = 400;
			}
		}
	}
}
