﻿package {
  import flash.utils.ByteArray;
  import flash.events.*;
  import flash.net.*;
  import flash.display.*;
  import flash.media.*;
  import flash.geom.*;

  public class SpectrumDisplay extends Sprite {
    // url dźwięku do wczytania
    private const SOUND_URL:String = "song.mp3"
    // liczba wartości na wykresie spektrum
    private const SPECTRUM_WIDTH:int = 256;
    // wysokość i szerokość grafiki
    private const BMP_HEIGHT:int = 200;
    private const BMP_WIDTH:int = 256;

    private var sound:Sound;
    // soundData będzie przechowywać tablicę ByteArray spektrum
    private var soundData:ByteArray;
    // bitmapData przechowuje informacje graficzne, podczas gdy
    // bitmapDisplay jest częścią listy wyświetlania
    private var bitmapData:BitmapData;
    private var bitmapDisplay:Bitmap;

    public function SpectrumDisplay () {
      sound = new Sound(new URLRequest(SOUND_URL));
      sound.play();
      // utwórz nowy obiekt BitmapData i dodaj tę bitmapę do listy wyświetlania
      bitmapData = new BitmapData(BMP_WIDTH, BMP_HEIGHT, true, 0x00000000);
      bitmapDisplay = new Bitmap(bitmapData);
      addChild(bitmapDisplay);
      this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    public function onEnterFrame (event:Event):void {
      // utwórz pustą tablice ByteArray do przechowywania danych spektrum
      soundData = new ByteArray();
      SoundMixer.computeSpectrum(soundData);
      // wyczyść poprzednią zawartość prostokąta
      bitmapData.fillRect(bitmapData.rect, 0xFF000000);
      // dla każdego kroku w lewym kanale

      for (var i:int=0; i < SPECTRUM_WIDTH; i++) {
        // pobierz amplitudę tej części spektrum w postaci liczby
        var amplitude:Number = soundData.readFloat();
        // pobierz wysokość pasma narysowanego w bitmapie
        var ampHeight:Number = BMP_HEIGHT/2 * (amplitude + 1);
        // utwórz prostokąt dla pasma
        var rect:Rectangle = new Rectangle(i, BMP_HEIGHT - ampHeight, 1, ampHeight);
        // narysuj prostokąt w bitmapie
        bitmapData.fillRect(rect, 0xffffffff);
      }
    }
  }
}
