﻿class XMLDataQueue
{
	private var pDataQueue:Array;
	private var pIsLoadActive:Boolean;
	private var pXML:XML;
	
	public function XMLDataQueue()
	{
		pDataQueue = new Array();
		pIsLoadActive = false;
	}
	
	// Add a request to load a file
	public function push(dataURL:String, callbackHandler:Function)
	{
		pDataQueue.push({url:dataURL, callback:callbackHandler});
		
		if (pIsLoadActive == false)
		{
			pIsLoadActive = true;
			loadNextData();
		}
	}
	
	// Load the next pending request in the list
	private function loadNextData():Void
	{
		var parent:XMLDataQueue = this;

		pXML = new XML();
		pXML.ignoreWhite = true;
		pXML.onLoad = function(status:Boolean)
		{
			parent.handleData(status);
		}

		pXML.load(pDataQueue[0].url);
	}

	// Get the data back from the currently loading request
	// and pass the data to a user-specified callback function
	private function handleData(status:Boolean):Void
	{
		// Call the callback function for this request, and remove
		// the request from the queue
		if (status == true)
		{
			pDataQueue[0].callback(pXML, pDataQueue[0].url);
		}
		else
		{
			pDataQueue[0].callback(null, pDataQueue[0].url);
		}
		pDataQueue.shift();
		
		// Make the next request, if there is still one in the queue
		if (pDataQueue.length > 0)
		{
			loadNextData();
		}
		else
		{
			pIsLoadActive = false;
		}
	}
}