﻿import flash.filters.DropShadowFilter;

class ThumbnailButton
{
    private var pParentTimeline:MovieClip;
	private var pThumbnailName:String;
	private var pThumbnailHolder:MovieClip;
	private var pImageHolder:MovieClip;
	private var pBorderHolder:MovieClip;
	private var pToolTipHolder:MovieClip;
	private var pClickHandler:Function;
	private var pMovieClipLoader:MovieClipLoader;
	private var pDrawDropShadow:Boolean = true;
	private var pDrawBorder:Boolean = true;


    public function ThumbnailButton(parentTimeline:MovieClip, thumbnailName:String)
    {
		pParentTimeline = parentTimeline;
		pThumbnailName = thumbnailName;
		
		pParentTimeline.createEmptyMovieClip(pThumbnailName, pParentTimeline.getNextHighestDepth());
		pThumbnailHolder = pParentTimeline[pThumbnailName];
		
		pThumbnailHolder.createEmptyMovieClip("imageHolder", pThumbnailHolder.getNextHighestDepth());
		pImageHolder = pThumbnailHolder.imageHolder;

		pThumbnailHolder.createEmptyMovieClip("borderHolder", pThumbnailHolder.getNextHighestDepth());
		pBorderHolder = pThumbnailHolder.borderHolder;

		pThumbnailHolder.createEmptyMovieClip("toolTipHolder", pThumbnailHolder.getNextHighestDepth());
		pToolTipHolder = pThumbnailHolder.toolTipHolder;
		pToolTipHolder.createTextField("toolTipText", pToolTipHolder.getNextHighestDepth(), 0, 0, 200, 20);
		pToolTipHolder.toolTipText.autoSize = true;
		
		pMovieClipLoader = new MovieClipLoader();
		pMovieClipLoader.addListener(this);
    }

    public function load(imageURL:String):Void
    {
        pMovieClipLoader.loadClip(imageURL, pImageHolder);
    }

	private function onLoadInit(targetMovieClip:MovieClip):Void
	{
		var parent:ThumbnailButton = this;
		
		drawThumbnail("up");

		pThumbnailHolder.onPress = function()
		{
			parent.drawThumbnail("down");
		}
		
		pThumbnailHolder.onRelease = function()
		{
			if (parent.pClickHandler != null)
			{
				parent.pClickHandler(parent);
			}
			parent.drawThumbnail("over");
		}
		
		pThumbnailHolder.onReleaseOutside = function()
		{
			parent.drawThumbnail("up");
		}
			
		pThumbnailHolder.onRollOver = function()
		{
			parent.drawThumbnail("over");
		}

		pThumbnailHolder.onRollOut = function()
		{
			parent.drawThumbnail("up");
		}
	}

	private function drawThumbnail(thumbnailState:String):Void
	{
		var dropShadowFilter:DropShadowFilter;
		var appliedFilterArray = new Array();
		pBorderHolder.clear();
		
		switch(thumbnailState)
		{
			case "up":
				dropShadowFilter = new DropShadowFilter(3, 45, 0x666666, 0.8, 5, 5, 1, 3, false, false, false);
				pImageHolder._x = pBorderHolder._x = 0;
				pImageHolder._y = pBorderHolder._y = 0;
				
				pToolTipHolder._visible = false;
				
				pBorderHolder.lineStyle(1, 0x666666);
				break;
			
			case "over":
				dropShadowFilter = new DropShadowFilter(3, 45, 0x000000, 1, 5, 5, 1, 5, false, false, false);
				pImageHolder._x = pBorderHolder._x = 0;
				pImageHolder._y = pBorderHolder._y = 0;
				
				pToolTipHolder._visible = true;
				pToolTipHolder._x = pImageHolder._width/2 - pToolTipHolder._width/2;
				pToolTipHolder._y = pImageHolder._height + 10;
				
				pBorderHolder.lineStyle(1, 0x000000);
				break;
				
			case "down":
				dropShadowFilter = new DropShadowFilter(1, 45, 0x000000, 1, 3, 3, 1, 5, false, false, false);
				pImageHolder._x = pBorderHolder._x = 2;
				pImageHolder._y = pBorderHolder._y = 2;
				
				pToolTipHolder._visible = true;
				pToolTipHolder._x = pImageHolder._width/2 - pToolTipHolder._width/2 + 2;
				pToolTipHolder._y = pImageHolder._height + 12;

				pBorderHolder.lineStyle(1, 0x990000);
				break;
		}
		
		if (pDrawBorder == true)
		{
			pBorderHolder.moveTo(0, 0);
			pBorderHolder.lineTo(pImageHolder._width-1, 0);
			pBorderHolder.lineTo(pImageHolder._width-1, pImageHolder._height-1);
			pBorderHolder.lineTo(0, pImageHolder._height-1);
			pBorderHolder.lineTo(0, 0);
		}
		
		if (pDrawDropShadow == true)
		{
			appliedFilterArray.push(dropShadowFilter);
			pThumbnailHolder.filters = appliedFilterArray;
		}
	}
	
	public function get onClick():Function
	{
		return pClickHandler;
	}
	
	public function set onClick(clickHandler:Function):Void
	{
		pClickHandler = clickHandler;
	}
	
	public function get x():Number
	{
		return pThumbnailHolder._x;
	}

	public function set x(xPosition:Number):Void
	{
		pThumbnailHolder._x = xPosition;
	}

	public function get y():Number
	{
		return pThumbnailHolder._y;
	}

	public function set y(yPosition:Number):Void
	{
		pThumbnailHolder._y = yPosition;
	}
	
	public function get drawBorder():Boolean
	{
		return pDrawBorder;
	}

	public function set drawBorder(drawBorderSetting:Boolean):Void
	{
		pDrawBorder = drawBorderSetting;
		drawThumbnail("up");
	}

	public function get drawDropShadow():Boolean
	{
		return pDrawDropShadow;
	}

	public function set drawDropShadow(drawDropShadowSetting:Boolean):Void
	{
		pDrawDropShadow = drawDropShadowSetting;
		drawThumbnail("up");
	}
	
	public function get thumbnailName():String
	{
		return pThumbnailName;
	}
	
	public function get toolTipText():String
	{
		return pToolTipHolder.toolTipText.text;
	}
	
	public function set toolTipText(newText:String):Void
	{
		var tempField:TextField = pToolTipHolder.toolTipText;
		pToolTipHolder.toolTipText.text = newText;
		
		var toolTipTextFormat:TextFormat = new TextFormat();
		toolTipTextFormat.font = "Arial";
		toolTipTextFormat.size = 12;
		toolTipTextFormat.color = 0x333333;
		
		tempField.setTextFormat(toolTipTextFormat);
	
		pToolTipHolder.clear();
		pToolTipHolder.lineStyle(1, 0x666666);
		pToolTipHolder.beginFill(0xFFF8B6, 100);
		pToolTipHolder.moveTo(tempField._x - 2, tempField._y - 2);
		pToolTipHolder.lineTo(tempField._x + tempField._width + 2, tempField._y - 2);
		pToolTipHolder.lineTo(tempField._x + tempField._width + 2, tempField._y + tempField._height);
		pToolTipHolder.lineTo(tempField._x - 2, tempField._y + tempField._height);
		pToolTipHolder.lineTo(tempField._x - 2, tempField._y - 2);
		pToolTipHolder.endFill();
	}
}

