﻿class PhotoData
{
	var pPhotoArray:Array;
	var pNumVisited:Number;
	
	public function PhotoData()
	{
		pPhotoArray = new Array();
		pNumVisited = 0;
	}
	
	public function addData(photoId:String, photoName:String, description:String, thumbnailURL:String, fullSizeURL:String, imageSize:Number):Void
	{
		var tempObject:Object = new Object();
		tempObject.id = photoId;
		tempObject.name = photoName;
		tempObject.description = description;
		tempObject.thumbnailURL = thumbnailURL;
		tempObject.fullSizeURL = fullSizeURL;
		tempObject.size = imageSize;
		tempObject.visited = false;
		
		pPhotoArray.push(tempObject);
	}
	
	public function getDataById(photoId:String):Object
	{
		var numPhotos:Number = pPhotoArray.length;
		for (var i:Number = 0; i < numPhotos; i++)
		{
			if (pPhotoArray[i].id == photoId)
			{
				return pPhotoArray[i];
			}
		}
		return null;
	}
	
	public function getDataByIndex(photoIndex:Number):Object
	{
		if (photoIndex >= 0 && photoIndex < pPhotoArray.length)
		{
			return pPhotoArray[photoIndex];
		}
	}
	
	public function get numPhotos():Number
	{
		return pPhotoArray.length;
	}
	
	public function get numVisited():Number
	{
		return pNumVisited;
	}
	
	public function setVisited(photoIndex:Number):Void
	{
		var tempData:Object = getDataByIndex(photoIndex);
		if (tempData != null)
		{
			tempData.visited = true;
			pNumVisited++;
		}
	}
	
	public function toString():String
	{
		var numPhotos:Number = pPhotoArray.length;
		var returnString:String = "";
		for (var i:Number = 0; i < numPhotos; i++)
		{
			returnString += "\n------------------------";
			returnString += "\nid:             " + pPhotoArray[i].id;
			returnString += "\nname:           " + pPhotoArray[i].name;
			returnString += "\ndescription:    " + pPhotoArray[i].description;
			returnString += "\nthumbnailURL:   " + pPhotoArray[i].thumbnailURL;
			returnString += "\nfullSizeURL:    " + pPhotoArray[i].fullSizeURL;
			returnString += "\nsize:           " + pPhotoArray[i].size;
			returnString += "\nvisited:        " + pPhotoArray[i].visited;
		}
		return returnString;
	}
}