﻿import mx.transitions.Tween;
import mx.transitions.easing.*;

this.createEmptyMovieClip("curveClip", this.getNextHighestDepth());

var isGrowing:Boolean = true;

var myTween:Tween = new Tween(null, "", Elastic.easeOut, 100, 0, 2, true);
myTween.onMotionChanged = function()
{
	if (isGrowing == false)
	{
		drawBox(20, 20, 125+this.position, 200+this.position, this.position/2);
	}
	else
	{
		drawBox(20, 20, 250-this.position, 360-this.position, -this.position/2);
	}
}

myTween.onMotionFinished = function()
{
	isGrowing = !isGrowing;
	this.rewind();
	this.start();
}

function drawBox(x:Number, y:Number, width:Number, height:Number, sidePush:Number):Void
{
	curveClip.clear();
	curveClip.lineStyle(1, 0x000000);
	curveClip.moveTo(x, y);
	curveClip.curveTo(x+sidePush, y+height/2, x, y+height);
	curveClip.curveTo(x+width/2, y+height-sidePush, x+width, y+height);
	curveClip.curveTo(x+width-sidePush, y+height/2, x+width, y);
	curveClip.curveTo(x+width/2, y+sidePush, x, y);
}
