﻿import mx.transitions.Tween;
import mx.transitions.easing.*;

this.createEmptyMovieClip("curveClip", this.getNextHighestDepth());

var direction:Number = -1;

var sidePushAmount:Number = 50;
var startWidth:Number = 125;
var endWidth:Number = 400;
var startHeight:Number = 200;
var endHeight:Number = 320;
var startX:Number = 20;
var endX:Number = 75;
var startY:Number = 20;
var endY:Number = 40;
var startAlpha:Number = 30;
var endAlpha:Number = 100;
var backgroundColor:Number = 0x990000;
var tweenDuration:Number = 2;

var sidePushTween:Tween = new Tween(null, "", Elastic.easeOut, sidePushAmount, 0, tweenDuration, true);
var widthTween:Tween = new Tween(null, "", Elastic.easeOut, startWidth, endWidth, tweenDuration, true);
var heightTween:Tween = new Tween(null, "", Elastic.easeOut, startHeight, endHeight, tweenDuration, true);
var xTween:Tween = new Tween(null, "", Elastic.easeOut, startX, endX, tweenDuration, true);
var yTween:Tween = new Tween(null, "", Elastic.easeOut, startY, endY, tweenDuration, true);
var alphaTween = new Tween(null, "", Elastic.easeOut, startAlpha, endAlpha, tweenDuration, true);

sidePushTween.onMotionChanged = function()
{
	drawBox(xTween.position, yTween.position, widthTween.position, heightTween.position, this.position * direction, backgroundColor, alphaTween.position);
}

sidePushTween.onMotionFinished = function()
{
	direction *= -1;
	this.rewind();
	this.start();
	widthTween.yoyo();
	heightTween.yoyo();
	xTween.yoyo();
	yTween.yoyo();
	alphaTween.yoyo();
}

function drawBox(x:Number, y:Number, width:Number, height:Number, sidePush:Number, backgroundColor:Number, backgroundAlpha:Number):Void
{
	curveClip.clear();
	curveClip.lineStyle(1, 0x000000);
	curveClip.beginFill(backgroundColor, backgroundAlpha);
	curveClip.moveTo(x, y);
	curveClip.curveTo(x+sidePush, y+height/2, x, y+height);
	curveClip.curveTo(x+width/2, y+height-sidePush, x+width, y+height);
	curveClip.curveTo(x+width-sidePush, y+height/2, x+width, y);
	curveClip.curveTo(x+width/2, y+sidePush, x, y);
	curveClip.endFill();
}
