﻿var ACCELERATION_RATE:Number = 0.5;
var EASING_FACTOR:Number = 10;
var MOVEMENT_AMOUNT:Number = 7;

var isRockDropping:Boolean = false;
var windEffect:Number = 0;

this.createEmptyMovieClip("holderClip", this.getNextHighestDepth());
holderClip.attachMovie("helicopter", "helicopter", holderClip.getNextHighestDepth());
holderClip.helicopter.targetX = 275;
holderClip.helicopter.verticalSpeed = 0;
holderClip.helicopter._x = holderClip.helicopter.targetX;
holderClip.helicopter._y = Stage.height - 14;

this.createTextField("windLabel", this.getNextHighestDepth(), 10, 10, 100, 20);
var windLabelTextFormat:TextFormat = new TextFormat();
windLabelTextFormat.font = "Arial";
windLabelTextFormat.size = 14;
windLabelTextFormat.bold = true;
windLabelTextFormat.color = 0xFFFFFF;

var intervalID:Number = setInterval(updateAnimation, 20);
function updateAnimation()
{
	checkKeys();
	if (holderClip.helicopter.targetX > 0 && holderClip.helicopter._y < Stage.height - 20)
	{
		holderClip.helicopter._x -= windEffect;
		holderClip.helicopter.targetX -= windEffect;
	}
	holderClip.helicopter._x += (holderClip.helicopter.targetX - holderClip.helicopter._x) / EASING_FACTOR;
	holderClip.helicopter._rotation = Math.min((holderClip.helicopter.targetX - holderClip.helicopter._x) / 5, 20);
	holderClip.helicopter.verticalSpeed += ACCELERATION_RATE;
	holderClip.helicopter._y += holderClip.helicopter.verticalSpeed;
	if (holderClip.helicopter._y >= Stage.height - 14)
	{
		holderClip.helicopter._y = Stage.height - 14;
		holderClip.helicopter.verticalSpeed = 0;
	}
		
	if (holderClip.rock)
	{
		holderClip.rock._y += holderClip.rock.speed;
		holderClip.rock._x -= windEffect;
		holderClip.rock.speed += ACCELERATION_RATE;
		if (holderClip.rock._y > Stage.height)
		{
			holderClip.rock.removeMovieClip();
			isRockDropping = false;
		}
	}
	updateAfterEvent();
}

var windIntervalID:Number = setInterval(updateWind, 5000)
function updateWind()
{
	windEffect = randomRange(-5, 5);
	windLabel.text = "Wind: " + Math.round(windEffect);
	windLabel.setTextFormat(windLabelTextFormat);
}
updateWind();

function moveShipLeft()
{
	holderClip.helicopter.targetX -= MOVEMENT_AMOUNT;
	if (holderClip.helicopter.targetX < 40)
	{
		holderClip.helicopter.targetX = 40;
	}
}

function moveShipRight()
{
	holderClip.helicopter.targetX += MOVEMENT_AMOUNT;
	if (holderClip.helicopter.targetX > Stage.width - 15)
	{
		holderClip.helicopter.targetX = Stage.width - 15;
	}
}

function moveShipUp()
{
	if (holderClip.helicopter.verticalSpeed > -5)
	{
		holderClip.helicopter.verticalSpeed -= 1;
	}
}

function moveShipDown()
{
	if (holderClip.helicopter.verticalSpeed < 5)
	{
		holderClip.helicopter.verticalSpeed += 1;
	}
}

// Initiate the drop of a rock from the helicopter
function dropRock()
{
	if (isRockDropping == false)
	{
		holderClip.attachMovie("rock", "rock", holderClip.getNextHighestDepth());
		holderClip.rock._x = holderClip.helicopter._x;
		holderClip.rock._y = holderClip.helicopter._y + 15;
		holderClip.rock.speed = 1;
		isRockDropping = true;
	}
}

// Detect which keys are pressed
function checkKeys()
{
	if (Key.isDown(Key.SPACE) == true)
	{
		dropRock();
	}

	if (Key.isDown(Key.LEFT) == true)
	{
		moveShipLeft();
	}

	if (Key.isDown(Key.RIGHT) == true)
	{
		moveShipRight();
	}
	
	if (Key.isDown(Key.UP) == true)
	{
		moveShipUp();
	}
	
	if (Key.isDown(Key.DOWN) == true)
	{
		moveShipDown();
	}
}

function randomRange(min:Number, max:Number)
{
	return Math.random() * (max - min) + min;
}