﻿var ACCELERATION_RATE:Number = 0.4;
var EASING_FACTOR:Number = 10;
var MOVEMENT_AMOUNT:Number = 7;

this.createEmptyMovieClip("holderClip", this.getNextHighestDepth());
holderClip.attachMovie("helicopter", "helicopter", holderClip.getNextHighestDepth());
holderClip.helicopter.targetX = 275;
holderClip.helicopter.verticalSpeed = 0;
holderClip.helicopter._x = holderClip.helicopter.targetX;
holderClip.helicopter._y = Stage.height - 14;

var intervalID:Number = setInterval(updateAnimation, 20);
function updateAnimation()
{
	checkKeys();
	
	holderClip.helicopter._x += (holderClip.helicopter.targetX - holderClip.helicopter._x) / EASING_FACTOR;
	holderClip.helicopter._rotation = Math.min((holderClip.helicopter.targetX - holderClip.helicopter._x) / 5, 20);
	holderClip.helicopter.verticalSpeed += ACCELERATION_RATE;
	
	holderClip.helicopter._y += holderClip.helicopter.verticalSpeed;
	if (holderClip.helicopter._y >= Stage.height - 14)
	{
		holderClip.helicopter._y = Stage.height - 14;
		holderClip.helicopter.verticalSpeed = 0;
	}
	
	updateAfterEvent();
}

function moveShipLeft()
{
	holderClip.helicopter.targetX -= MOVEMENT_AMOUNT;
	if (holderClip.helicopter.targetX < 40)
	{
		holderClip.helicopter.targetX = 40;
	}
}

function moveShipRight()
{
	holderClip.helicopter.targetX += MOVEMENT_AMOUNT;
	if (holderClip.helicopter.targetX > Stage.width - 15)
	{
		holderClip.helicopter.targetX = Stage.width - 15;
	}
}

function moveShipUp()
{
	if (holderClip.helicopter.verticalSpeed > -5)
	{
		holderClip.helicopter.verticalSpeed -= 1;
	}
}

function moveShipDown()
{
	if (holderClip.helicopter.verticalSpeed < 5)
	{
		holderClip.helicopter.verticalSpeed += 1;
	}
}

function checkKeys()
{
	if (Key.isDown(Key.LEFT) == true)
	{
		moveShipLeft();
	}

	if (Key.isDown(Key.RIGHT) == true)
	{
		moveShipRight();
	}
	
	if (Key.isDown(Key.UP) == true)
	{
		moveShipUp();
	}
	
	if (Key.isDown(Key.DOWN) == true)
	{
		moveShipDown();
	}
}
