﻿this.createEmptyMovieClip("holderClip", this.getNextHighestDepth());
holderClip.maxFlakes = 50;
holderClip.dropSpeed = 5;

var thisFlake:MovieClip;
for (var i:Number = 0; i < holderClip.maxFlakes; i++)
{
    holderClip.attachMovie("snowFlake", "snowFlake" + i, holderClip.getNextHighestDepth());
    thisFlake = holderClip["snowFlake" + i];
    thisFlake._x = randomRange(0, Stage.width);
    thisFlake._y = randomRange(0, Stage.height);
    thisFlake._xscale = thisFlake._yscale = randomRange(50, 150);
    thisFlake._alpha = thisFlake._xscale - 50;
    thisFlake.cacheAsBitmap = true;
    thisFlake.oscillationSeed = randomRange(0, 200);
	thisFlake.rotationRate = randomRange(-7, 7);
}

holderClip.onEnterFrame = function()
{
    var thisFlake:MovieClip;
    for (var i:Number = 0; i < this.maxFlakes; i++)
    {
        thisFlake = this["snowFlake" + i];
        thisFlake._y += thisFlake._xscale * (this.dropSpeed / 100);
        thisFlake._x += Math.sin((thisFlake._y + thisFlake.oscillationSeed) / 50);
		thisFlake._rotation += thisFlake.rotationRate;
		
        if (thisFlake._y >= Stage.height)
        {
            thisFlake._x = randomRange(0, Stage.width);
            thisFlake._y = 0;
        }
    }
}

function randomRange(min:Number, max:Number)
{
    return Math.random() * (max - min) + min;
}
