﻿var easingFactor:Number = 20;
var deltaX:Number;
var deltaY:Number;
var angle:Number;

this.createEmptyMovieClip("animationHolder", this.getNextHighestDepth());
animationHolder.attachMovie("cursorSymbol", "cursorSymbolLeft", animationHolder.getNextHighestDepth());
animationHolder.attachMovie("cursorSymbol", "cursorSymbolRight", animationHolder.getNextHighestDepth());
animationHolder.onEnterFrame = function()
{
	// Make the eyes follow the mouse
	this.cursorSymbolLeft._x += (_xmouse - this.cursorSymbolLeft._x) / easingFactor;
	this.cursorSymbolRight._x = this.cursorSymbolLeft._x + 11
	this.cursorSymbolLeft._y += (_ymouse - this.cursorSymbolLeft._y) / easingFactor;
	this.cursorSymbolRight._y = this.cursorSymbolLeft._y

	// Track the mouse position relative to the animation. Figure out
	// how much to rotate the eyes
	deltaX = this.cursorSymbolLeft._x - _xmouse;
	deltaY = this.cursorSymbolLeft._y - _ymouse;

	if (deltaX <= 0 && deltaY > 0)
	{
		// The mouse is top-right of the eyes
		angle = -Math.atan(deltaX / deltaY);		
		angle = angle * 57.2957795 - 90;
	}
	else if (deltaX < 0 && deltaY <= 0)
	{
		// The mouse is bottom-right of the eyes
		angle = Math.atan(deltaY / deltaX);		
		angle = angle * 57.2957795;
	}
	else if (deltaX >= 0 && deltaY < 0)
	{
		// The mouse is bottom-left of the eyes
		angle = -Math.atan(deltaX / deltaY);		
		angle = angle * 57.2957795 + 90;
	}
	else
	{
		// The mouse is top-left of the eyes
		angle = Math.atan(deltaY / deltaX);		
		angle = angle * 57.2957795 + 180;
	}
	// Adjust the angle, since the pupils aren't in-line with the calculated angle
	angle -= 40;
	// Rotate both eyes
	this.cursorSymbolLeft._rotation = this.cursorSymbolRight._rotation = angle;
}

