﻿var mediaListListener:Object = new Object();
mediaListListener.change = function(eventObject:Object)
{
	if (eventObject.target._name == "imageList")
	{
		movieList.selectedIndex = null;
	}
	else if (eventObject.target._name == "movieList")
	{
		imageList.selectedIndex = null;
	}
}

var mediaViewerListener:Object = new Object();
mediaViewerListener.change = function(eventObject:Object)
{
	if (eventObject.target._name == "imageList")
	{
		loadMedia(eventObject.target.selectedItem.data, "image");
	}
	else if (eventObject.target._name == "movieList")
	{
		loadMedia(eventObject.target.selectedItem.data, "video");
	}
	else if (eventObject.target._name == "zoomStepper")
	{
		setZoom(eventObject.target.value);
	}
}

mediaViewerListener.progress = function(eventObject:Object)
{
    var bytesLoaded:Number = eventObject.target.getBytesLoaded();
    var bytesTotal:Number = eventObject.target.getBytesTotal();
    trace("Image Viewer Progress: "+bytesLoaded+"/"+bytesTotal);
    if(bytesLoaded == -1)
    {
        loadImageError();
    }
    else
    {
        mediaViewerProgress.setProgress(bytesLoaded, bytesTotal);
    }
}

mediaViewerListener.complete = function(eventObject:Object)
{
    trace("Image Viewer Complete");
    mediaViewerProgress._visible = false;
    setZoom(zoomStepper.value);
}

function init(): Void
{
   // Przesyłanie danych do komponentów imageList oraz movieList. 
   mediaListXMLConnector.direction = "receive";
   mediaListXMLConnector.URL = "mediaList.xml";
   mediaListXMLConnector.trigger();

   imageList.addEventListener("change", mediaListListener);
   imageList.addEventListener("change", mediaViewerListener);

   movieList.addEventListener("change", mediaListListener);
   movieList.addEventListener("change", mediaViewerListener);

   // Przygotowanie komponentu zoomStepper.
   zoomStepper.maximum = 400;
   zoomStepper.minimum = 25;
   zoomStepper.stepSize = 25;
   zoomStepper.value = 100;
   zoomStepper.addEventListener("change", mediaViewerListener);

   // Przygotowanie komponentu mediaViewerProgress.
   mediaViewerProgress.mode = "manual";
   mediaViewerProgress._visible = false;

   // Przygotowanie komponentu mediaViewerPane.
   mediaViewerPane.scrollDrag = true;
   mediaViewerPane.addEventListener("progress", mediaViewerListener);
   mediaViewerPane.addEventListener("complete", mediaViewerListener);

   // Definicje stylów dla aplikacji.

   // Style globalne.
   _global.style.setStyle("borderStyle", "solid");
   _global.style.setStyle("fontFamily", "alternateFont");
   _global.style.setStyle("fontSize", 12);
   _global.style.setStyle("embedFonts", true);
   _global.style.setStyle("color", 0x666666);
   _global.style.setStyle("themeColor", 0xDDDDFF);
   _global.style.setStyle("textSelectedColor", 0x000000);

   // Style dla wszystkich komponentów Label.
   if (_global.styles.Label == undefined)
   {
      _global.styles.Label = new mx.styles.CSSStyleDeclaration();
   }
   _global.styles.Label.setStyle("color", 0x003399);
   _global.styles.Label.setStyle("fontWeight", "bold");

   // Styl dla tytułu.
   var appTitleStyle:Object = new mx.styles.CSSStyleDeclaration();
   _global.styles.appTitle = appTitleStyle;
   appTitleStyle.setStyle("fontSize", 20);
   appTitleStyle.setStyle("fontWeight", "bold");
   appTitleStyle.setStyle("color", 0x000000);
   appTitleLabel.setStyle("styleName", "appTitle");

   // Style dla instancji komponentów.
   zoomStepper.setStyle("textAlign", "left");
}

function loadMedia(mediaPath:String, type:String) : Void
{
	trace("loading: " + mediaPath);
	if (mediaPath != "" && mediaPath != undefined)
	{
		mediaViewerPane.contentPath = "";
		mediaViewerPane.contentPath = mediaPath;
		mediaViewerProgress._visible = true;
		mediaViewerProgress.setProgress(0, 100);
	}
}

function loadMediaError() : Void
{
	trace("loadMediaError");
	mediaViewerProgress._visible = false;
	imageList.selectedIndex = null;
	videoList.selectedIndex = null;
	mediaViewerPane.contentPath = "";
}

function setZoom(zoomValue:Number) : Void
{
	mediaViewerPane.content._xscale = zoomValue;
	mediaViewerPane.content._yscale = zoomValue;	
	mediaViewerPane.invalidate();
}

init();
