﻿var mediaListListener:Object = new Object();
mediaListListener.change = function(eventObject:Object)
{
	if (eventObject.target._name == "imageList")
	{
		movieList.selectedIndex = null;
	}
	else if (eventObject.target._name == "movieList")
	{
		imageList.selectedIndex = null;
	}
}

var mediaViewerListener:Object = new Object();
mediaViewerListener.change = function(eventObject:Object)
{
	if (eventObject.target._name == "imageList")
	{
		loadMedia(eventObject.target.selectedItem.data, "image");
	}
	else if (eventObject.target._name == "movieList")
	{
		loadMedia(eventObject.target.selectedItem.data, "video");
	}
	else if (eventObject.target._name == "zoomStepper")
	{
		setZoom(eventObject.target.value);
	}
}

mediaViewerListener.progress = function(eventObject:Object)
{
    var bytesLoaded:Number = eventObject.target.getBytesLoaded();
    var bytesTotal:Number = eventObject.target.getBytesTotal();
    trace("Image Viewer Progress: "+bytesLoaded+"/"+bytesTotal);
    if(bytesLoaded == -1)
    {
        loadImageError();
    }
    else
    {
        mediaViewerProgress.setProgress(bytesLoaded, bytesTotal);
    }
}

mediaViewerListener.complete = function(eventObject:Object)
{
    trace("Image Viewer Complete");
    mediaViewerProgress._visible = false;
    setZoom(zoomStepper.value);
}

function init(): Void
{
   // Przesyłanie danych do komponentów imageList oraz movieList. 
   mediaListXMLConnector.direction = "receive";
   mediaListXMLConnector.URL = "mediaList.xml";
   mediaListXMLConnector.trigger();

   imageList.addEventListener("change", mediaListListener);
   imageList.addEventListener("change", mediaViewerListener);

   movieList.addEventListener("change", mediaListListener);
   movieList.addEventListener("change", mediaViewerListener);

   // Przygotowanie komponentu zoomStepper.
   zoomStepper.maximum = 400;
   zoomStepper.minimum = 25;
   zoomStepper.stepSize = 25;
   zoomStepper.value = 100;
   zoomStepper.addEventListener("change", mediaViewerListener);

   // Przygotowanie komponentu mediaViewerProgress.
   mediaViewerProgress.mode = "manual";
   mediaViewerProgress._visible = false;

   // Przygotowanie komponentu mediaViewerPane.
   mediaViewerPane.scrollDrag = true;
}


init();
