﻿import mx.controls.Button;
import mx.controls.DataGrid;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.TextArea;
import mx.styles.CSSStyleDeclaration;

var notesList:Array = new Array();
notesList.push({title:"Note 1", size:0, text:"Szybki brązowy lis..." });
notesList.push({title:"Note 2", size:0, text:"Szybki brązowy..." });
notesList.push({title:"Note 3", size:0, text:"Szybki lis..." });

notesList[0].size = notesList[0].text.length;
notesList[1].size = notesList[1].text.length;
notesList[2].size = notesList[2].text.length;

function drawScreen():Void 
{
   this.createClassObject(Label, "gridTitle", this.getNextHighestDepth());
   gridTitle.text = "Notes";
   gridTitle._x = 18;
   gridTitle._y = 18;

   this.createClassObject(DataGrid, "notesDataGrid", this.getNextHighestDepth());
   notesDataGrid._x = 18;
   notesDataGrid._y = 40;
   notesDataGrid.setSize(225, 170);

   notesDataGrid.addColumn("title");
   notesDataGrid.addColumn("size");
   notesDataGrid.getColumnAt(0).width = 165;
   notesDataGrid.getColumnAt(0).headerText = "Title";
   notesDataGrid.getColumnAt(1).headerText = "Size";
   notesDataGrid.dataProvider = notesList;

   this.createClassObject(Button, "addButton", this.getNextHighestDepth());
   addButton.label = "Add";
   addButton._x = 18;
   addButton._y = 219;
   addButton.setSize(100, 22);

   this.createClassObject(Button, "deleteButton", this.getNextHighestDepth());
   deleteButton.label = "Delete";
   deleteButton._x = 142;
   deleteButton._y = 219;
   deleteButton.setSize(100, 22);
   deleteButton.enabled = false;

   this.createClassObject(Label, "noteTitle", this.getNextHighestDepth());
   noteTitle.text = "Title";
   noteTitle._x = 272;
   noteTitle._y = 18;

   this.createClassObject(TextInput, "titleField", this.getNextHighestDepth());
   titleField._x = 272;
   titleField._y = 40;
   titleField.setSize(225, 22);

   this.createClassObject(Label, "textTitle", this.getNextHighestDepth());
   textTitle.text = "Text";
   textTitle._x = 272;
   textTitle._y = 88;

   this.createClassObject(TextArea, "noteTextField", this.getNextHighestDepth())
   noteTextField._x = 272;
   noteTextField._y = 109;
   noteTextField.setSize(225, 100);
   noteTextField.wordWrap = true;

   this.createClassObject(Button, "saveButton", this.getNextHighestDepth());
   saveButton.label = "Save";
   saveButton._x = 395;
   saveButton._y = 219;
   saveButton.setSize(100, 22);
   saveButton.enabled = false;

   // Definiowanie stylów globalnych
   _global.style.setStyle("themeColor", 0xAAAAEE);
   _global.style.setStyle("fontFamily", "Verdana");
   _global.style.setStyle("fontSize", 11) ;
   _global.style.setStyle("color", 0x666666);

   //Definiowanie stylów komponentów
   _global. styles. Label = new CSSStyleDeclaration();
   _global.styles.Label.setStyle("fontSize", 14);
   _global.styles.Label.setStyle("fontWeight", "bold");
   _global.styles.Label.setStyle("color", 0x000000);

   _global. styles. Button = new CSSStyleDeclaration();
   _global.styles.Button.setStyle("fontWeight", "bold");
   _global.styles.Button.setStyle("color", 0x333399);
   _global.styles.Button.setStyle("buttonColor", 0xAAAAEE);

   // Definiowanie stylów indywidualnych instancji
   notesDataGrid.setStyle("vGridLines", false);
   notesDataGrid.setStyle("hGridLines", false);
   notesDataGrid.setStyle("headerColor", 0xBBBBFF);

   var headerStyle = new CSSStyleDeclaration();
   headerStyle.setStyle("fontWeight", "bold");
   notesDataGrid.setStyle("headerStyle", headerStyle);

   deleteButton.setStyle("color", 0x990000);
}

drawScreen();

//Procedura obsługi wpisywania w polach title lub note
var handleNoteChangeListener:Object = new Object();
handleNoteChangeListener.change = function()
{
   saveButton.enabled = true;
}
titleField.addEventListener("change", handleNoteChangeListener);
noteTextField.addEventListener("change", handleNoteChangeListener);

// Procedura obsługi wyboru notatki z listy
var handleNoteListener:Object = new Object();
handleNoteListener.change = function(eventObject:Object)
{
   titleField.text = eventObject.target.selectedItem.title;
   noteTextField.text = eventObject.target.selectedItem.text;
   deleteButton.enabled = true;
}
notesDataGrid.addEventListener("change", handleNoteListener);

// Obsługa przycisku Delete
var handleDeleteListener:Object = new Object();
handleDeleteListener.click = function()
{
   trace("selectedIndex: " + notesDataGrid.selectedIndex);
   var selectedRow:Number = notesDataGrid.selectedIndex;
   notesList.splice(selectedRow, 1);
   notesDataGrid.dataProvider = notesList;
   // Alternatywnie, poniższa linia może zastąpić dwie powyższe
   // notesDataGrid.dataProvider.removeItemAt(selectedRow);

if (notesList.length > 0)
{
   // Jeżeli lista nie jest pusta
   if (selectedRow < notesList.length)
   {
      // Wybór wiersza, który zastąpi usunięty wiersz
      notesDataGrid.selectedIndex = selectedRow; 
   }
   else
   {
      // Jeżeli brak wierszy, które mogłyby zastąpić
      // wybrany wiersz, wykorzystywany jest wiersz ostatni
      notesDataGrid.selectedIndex = notesList.length - 1;
   }
   notesDataGrid.dispatchEvent({type:"change", target:notesDataGrid});
   }
   else
   {
      // Jeżeli lista jest pusta
      deleteButton.enabled = false;
   }
}
deleteButton.addEventListener("click", handleDeleteListener);

// Obsługa przycisku Add
var handleAddListener:Object = new Object();
handleAddListener.click = function()
{
   notesDataGrid.addItem({title:"New note", size:0, text:" "});
   notesDataGrid.selectedIndex = notesList.length - 1;
   titleField.text = "New note";
   noteTextField.text = " ";
   deleteButton.enabled = true;
}
addButton.addEventListener("click", handleAddListener);

// Obsługa przycisku Save
var handleSaveListener:Object = new Object();
handleSaveListener.click = function()
{
   notesDataGrid.editField(notesDataGrid.selectedIndex, "title", titleField.text);
   notesDataGrid.editField(notesDataGrid.selectedIndex, "size", 
   noteTextField.text.length);
   notesDataGrid.editField(notesDataGrid.selectedIndex, "text",
   noteTextField.text);
}
saveButton.addEventListener("click", handleSaveListener);
