﻿// Zmiany w kodzie obsługi komponentu List.
var mediaListListener:Object = new Object();
mediaListListener.change = function(eventObject:Object)
{
   if (eventObject.target._name == "imageList")
   {
      movieList.selectedIndex = null;
   }
   else if (eventObject.target._name == "movieList")
   {
      imageList.selectedIndex = null;
   }
}

// Obiekt nasłuchujący dla komponentu zoomStepper usunięty.

// Zmiany w kodzie obsługi głównego obszaru zawartości.
var mediaViewerListener:Object = new Object();
mediaViewerListener.change = function(eventObject:Object)
{
   if (eventObject.target._name == "imageList")
   {
      loadMedia(eventObject.target.selectedItem.data, "image");
   }
   else if (eventObject.target._name == "movieList")
   {
      loadMedia(eventObject.target.selectedItem.data, "video");
   }
   else if (eventObject.target._name == "zoomStepper")
   {
      setZoom(eventObject.target.value);
   }
}

mediaViewerListener.progress = function(eventObject:Object)
{
   var bytesLoaded:Number = eventObject.target.getBytesLoaded();
   var bytesTotal:Number = eventObject.target.getBytesTotal();
   trace("Załadowano: " + bytesLoaded + "/" + bytesTotal);
   if(bytesLoaded == -1)
   {
      loadImageError();
   }
   else
   {
      mediaViewerProgress.setProgress(bytesLoaded, bytesTotal);
   }
}

mediaViewerListener.complete = function(eventObject:Object)
{
   trace("Podgląd dostępny");
   mediaViewerProgress._visible = false;
   setZoom(zoomStepper.value);
}

function init(): Void
{
   // Przesyłanie danych do komponentu imageList.
   var imageArray:Array = new Array();
   imageArray.push({data:"images/aStudyInTexture.jpg", label:"A Study In Texture"});
   imageArray.push({data:"images/buntzenWinter.jpg", label:"Buntzen Winter"});
   imageArray.push({data:"images/flowerInDetail.jpg", label:"Flower In Detail"});
   imageArray.push({data:"images/galianoSunset.jpg", label:"Galiano Sunset"});
   imageList.dataProvider = imageArray;
   imageList.addEventListener("change", mediaListListener);
   imageList.addEventListener("change", mediaViewerListener);

   // Przesyłanie danych do komponentu movieList.
   var movieArray:Array = new Array();
   movieArray.push({data:"movies/animation.swf", label:"Animation"});
   movieArray.push({data:"movies/snowStorm.swf", label:"Snow Storm"});
   movieList.dataProvider = movieArray;
   movieList.addEventListener("change", mediaListListener);
   movieList.addEventListener("change", mediaViewerListener);

   // Przygotowanie komponentu ProgressBar.
   mediaViewerProgress.mode = "manual";
   mediaViewerProgress._visible = false;

   // Przygotowanie komponentu ScrollPane.
   mediaViewerPane.scrollDrag = true;
   mediaViewerPane.addEventListener("progress", mediaViewerListener);
   mediaViewerPane.addEventListener("complete", mediaViewerListener);

   // Przygotowanie komponentu NumericStepper.
   zoomStepper.maximum = 400;
   zoomStepper.minimum = 25;
   zoomStepper.stepSize = 25;
   zoomStepper.value = 100;
   zoomStepper.addEventListener("change", mediaViewerListener);
}

function loadMedia(mediaPath:String, type:String) : Void
{
   trace("ładowanie pliku: " + mediaPath);
   if (mediaPath != "" && mediaPath != undefined)
   {
      mediaViewerPane.contentPath = "";
      mediaViewerPane.contentPath = mediaPath;
      mediaViewerProgress._visible = true;
      mediaViewerProgress.setProgress(0, 100);
   }
}

function loadMediaError() : Void
{
   trace("loadMediaError");
   mediaViewerProgress._visible = false;
   imageList.selectedIndex = null;
   videoList.selectedIndex = null;
   mediaViewerPane.contentPath = " ";
}

function setZoom(zoomValue:Number): Void
{
   mediaViewerPane.content._xscale = zoomValue;
   mediaViewerPane.content._yscale = zoomValue;
   mediaViewerPane.invalidate();
}

init();
