﻿import mx.controls.Button;
import mx.controls.DataGrid;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.TextArea;

var notesList:Array = new Array();
notesList.push({title:"Notatka 1", size:0, text:"Szybki brązowy lis..." });
notesList.push({title:"Notatka 2", size:0, text:"Szybki brązowy..." });
notesList.push({title:"Notatka 3", size:0, text:"Szybki lis..." });

notesList[0].size = notesList[0].text.length;
notesList[1].size = notesList[1].text.length;
notesList[2].size = notesList[2].text.length;

function drawScreen():Void 
{
   this.createClassObject(Label, "gridTitle", this.getNextHighestDepth());
   gridTitle.text = "Notes";
   gridTitle._x = 18;
   gridTitle._y = 18;

   this.createClassObject(DataGrid, "notesDataGrid", this.getNextHighestDepth());
   notesDataGrid._x = 18;
   notesDataGrid._y = 40;
   notesDataGrid.setSize(225, 170);

   notesDataGrid.addColumn("title");
   notesDataGrid.addColumn("size");
   notesDataGrid.getColumnAt(0).width = 165;
   notesDataGrid.getColumnAt(0).headerText = "Title";
   notesDataGrid.getColumnAt(1).headerText = "Size";
   notesDataGrid.dataProvider = notesList;

   this.createClassObject(Button, "deleteButton", this.getNextHighestDepth());
   deleteButton.label = "Delete";
   deleteButton._x = 18;
   deleteButton._y = 219;
   deleteButton.setSize(100, 22);
   deleteButton.enabled = false;

   this.createClassObject(Label, "noteTitle", this.getNextHighestDepth());
   noteTitle.text = "Title";
   noteTitle._x = 272;
   noteTitle._y = 18;

   this.createClassObject(TextInput, "titleField", this.getNextHighestDepth());
   titleField._x = 272;
   titleField._y = 40;
   titleField.setSize(225, 22);

   this.createClassObject(Label, "textTitle", this.getNextHighestDepth());
   textTitle.text = "Text";
   textTitle._x = 272;
   textTitle._Y = 88;

   this.createClassObject(TextArea, "noteTextField", this.getNextHighestDepth())
   noteTextField._x = 272;
   noteTextField._y = 109;
   noteTextField.setSize(225, 100);
   noteTextField.enabled = true;

   this.createClassObject(Button, "addButton", this.getNextHighestDepth());
   addButton.label = "Add";
   addButton._x = 272;
   addButton._y = 219;
   addButton.setSize(100, 22);
   addButton.enabled = false;

   this.createClassObject(Button, "saveButton", this.getNextHighestDepth());
   saveButton.label = "Save";
   saveButton._x = 395;
   saveButton._y = 219;
   saveButton.setSize(100, 22);
   saveButton.enabled = false;

}

drawScreen();

// Procedura obsługi wpisywania w polach title lub note
var handleNoteChangeListener:Object = new Object();
handleNoteChangeListener.change = function()
{
   addButton.enabled = true;
   saveButton.enabled = true;
}
titleField.addEventListener("change", handleNoteChangeListener);
noteTextField.addEventListener("change", handleNoteChangeListener);

// Procedura obsługi wyboru notatki z listy
var handleNoteListener:Object = new Object();
handleNoteListener.change = function(eventObject:Object)
{
   titleField.text = eventObject.target.selectedItem.title;
   noteTextField.text = eventObject.target.selectedItem.text;
   deleteButton.enabled = true;
}
notesDataGrid.addEventListener("change", handleNoteListener);

// Obsługa przycisku Delete
var handleDeleteListener:Object = new Object();
handleDeleteListener.click = function()
{
   trace("selectedIndex: " + notesDataGrid.selectedIndex);
   var selectedRow:Number = notesDataGrid.selectedIndex;
   notesList.splice(selectedRow, 1);
   notesDataGrid.dataProvider = notesList;
   // Alternatywnie, poniższa linia może zastąpić dwie powyższe
   // notesDataGrid.dataProvider.removeItemAt(selectedRow);

if (notesList.length > 0)
{
   // Jeżeli lista nie jest pusta
   if (selectedRow < notesList.length)
   {
      // Wybór wiersza, który zastąpi usunięty wiersz
      notesDataGrid.selectedIndex = selectedRow;
   }
   else
   {
      // Jeżeli brak wierszy, które mogłyby zastąpić
      // wybrany wiersz, wykorzystywany jest wiersz ostatni
      notesDataGrid.selectedIndex = notesList.length - 1;
   }
   notesDataGrid.dispatchEvent({type:"change", target:notesDataGrid});
   }
   else
   {
      // Jeżeli lista jest pusta
      deleteButton.enabled = false;
   }
}
deleteButton.addEventListener("click", handleDeleteListener);

// Obsługa przycisku Add
var handleAddListener:Object = new Object();
handleAddListener.click = function()
{
   notesList.push({title:titleField.text, size:noteTextField.text.length,
   text:noteTextField.text});
   notesDataGrid.selectedIndex = notesList.length - 1;
   deleteButton.enabled = true;
}
addButton.addEventListener("click", handleAddListener);

// Obsługa przycisku Save
var handleSaveListener:Object = new Object();
handleSaveListener.click = function()
{
   notesDataGrid.editField(notesDataGrid.selectedIndex, "title", titleField.text);
   notesDataGrid.editField(notesDataGrid.selectedIndex, "size", 
   noteTextField.text.length);
   notesDataGrid.editField(notesDataGrid.selectedIndex, "text",
   noteTextField.text);
}
saveButton.addEventListener("click", handleSaveListener);
