﻿this.createEmptyMovieClip("movieHolder", this.getNextHighestDepth());
// Requires: a ProgressBar component placed in the library
this.createClassObject(mx.controls.ProgressBar, "progressComponent", this.getNextHighestDepth());

progressComponent._x = 60;
progressComponent._y = 120;
progressComponent.mode = "manual";

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
    progressComponent._visible = true;
	progressComponent.setProgress(0, 100);
    contentHolder._visible = false;
    contentHolder.stop();
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
 	progressComponent.setProgress(bytesLoaded, bytesTotal);
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    progressComponent._visible = false;
    contentHolder._visible = true;
    contentHolder.play();
};

loadListener.onLoadError = function(contentHolder:MovieClip, errorCode:String)
{
	if (errorCode == "URLNotFound")
	{
	    progressComponent.label = "Nie udało się załadować mediów.";
	}
	else if (errorCode == "LoadNeverCompleted")
	{
	    progressComponent.label = "Transfer przerwany.";
	}
};

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("exercise1Trailer.swf", movieHolder);