﻿this.createEmptyMovieClip("movieHolder", this.getNextHighestDepth());
this.createEmptyMovieClip("progressMovie", this.getNextHighestDepth());
progressMovie._x = 60;
progressMovie._y = 120;
progressMovie.createTextField("percentDoneLabel", progressMovie.getNextHighestDepth(), 40, 0, 200, 20);

var loadListener:Object = new Object();
loadListener.onLoadStart = function(contentHolder:MovieClip)
{
    progressMovie._visible = true;
    contentHolder._visible = false;
    contentHolder.stop();
};

loadListener.onLoadProgress = function(contentHolder:MovieClip, bytesLoaded:Number, bytesTotal:Number)
{
    var percentDone:Number = bytesLoaded / bytesTotal * 100;
    showProgress(percentDone, progressMovie);
};

loadListener.onLoadComplete = function(contentHolder:MovieClip)
{
    progressMovie._visible = false;
    contentHolder._visible = true;
    contentHolder.play();
};
loadListener.onLoadError = function(contentHolder:MovieClip, errorCode:String)
{
	if (errorCode == "URLNotFound")
	{
	    progressMovie.percentDoneLabel.text = "BŁĄD: nie udało się załadować mediów.";
	    progressMovie.clear();
	}
	else if (errorCode == "LoadNeverCompleted")
	{
	    progressMovie.percentDoneLabel.text = "BŁĄD: transfer przerwany.";
	    progressMovie.clear();
	}
}

var contentLoader:MovieClipLoader = new MovieClipLoader();
contentLoader.addListener(loadListener);
contentLoader.loadClip("exercise1Trailer.swf", movieHolder);
//contentLoader.loadClip("clipThatDoesNotExist.swf", movieHolder);
          
function showProgress(percentDone:Number, progressBarHolder:MovieClip) : Void
{
    var barWidth:Number = percentDone;
    progressBarHolder.percentDoneLabel.text = String(Math.ceil(percentDone))+" %";
    progressBarHolder.clear();
        
    // Rysowanie obramowania.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.lineStyle(1, 0x666666);
    progressBarHolder.lineTo(100, 20);
    progressBarHolder.lineTo(100, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    
    // Rysowanie paska postępu.
    progressBarHolder.moveTo(0, 20);
    progressBarHolder.beginFill(0xCCCCCC, 100);
    progressBarHolder.lineTo(barWidth, 20);
    progressBarHolder.lineTo(barWidth, 30);
    progressBarHolder.lineTo(0, 30);
    progressBarHolder.lineTo(0, 20);
    progressBarHolder.endFill();
}
