﻿var currentYear:Number;
var currentMonth:Number;
var currentDate:Number;

// Połączenie nazw miesięcy z odpowiednimi liczbami
var monthArray = new Array("Styczeń", "Luty", "Marzec", "Kwiecień", "Maj", "Czerwiec", "Lipiec", "Sierpień", "Wrzesień", "Październik", "Listopad", "Grudzień");

function createButton(buttonName:String, buttonLabel:String, buttonData:String, parentClip:MovieClip, xPos:Number, yPos:Number, buttonWidth:Number, buttonHeight:Number, buttonHandler:Function):Void
{
   var newClip:MovieClip = parentClip.createEmptyMovieClip(buttonName,
   parentClip.getNextHighestDepth());

   newClip._x = xPos;
   newClip._y = yPos;

   newClip.moveTo(0, 0);
   newClip.lineStyle(1, 0x666666);
   newClip.beginFill(0xFFFFFF, 100);
   newClip.lineTo(buttonWidth, 0);
   newClip.lineTo(buttonWidth, buttonHeight);
    newClip.lineTo(0, buttonHeight);
   newClip.lineTo(0, 0);
   newClip.endFill();

   newClip.createTextField("labelField", newClip.getNextHighestDepth(), 2,
   buttonHeight/2 - 7, buttonWidth - 4, 14);
   newClip.labelField.text = buttonLabel;
   newClip.buttonData = buttonData; 
   newClip.onRelease = function()
   {
      // Wywołanie funkcji przekazywanej jako argument
      buttonHandler(this.buttonData);
   }
}

function deleteButton(buttonName:String):Void 
{
   this[buttonName].removeMovieClip();
}

function setWeek(year:Number, month:Number, date:Number):Void
{
   var thisDate:Date = new Date(year, month, date);
   monthYearLabel.text = monthArray[month] + " " + year;

   for (var i:Number = 0; i < 7; i++) 
   {
      deleteButton("day" + i + "button");
      createButton ("day" + i + "button", String (thisDate.getDate ()),
      thisDate.toString(), this, 60 + (i * 30), 40, 20, 20, handleDateSelected);
      thisDate.setDate(thisDate.getDate() + 1);
   }
}

function handlePreviousWeek():Void
{
   var thisDate:Date = new Date(currentYear, currentMonth, currentDate);
   thisDate.setDate(thisDate.getDate() - 7);

   currentYear = thisDate.getYear() + 1900;
   currentMonth = thisDate.getMonth();
   currentDate = thisDate.getDate();

   setWeek(currentYear, currentMonth, currentDate);
}

function handleNextWeek():Void 
{
   var thisDate:Date = new Date(currentYear, currentMonth, currentDate);
   thisDate.setDate(thisDate.getDate() + 7);

   currentYear = thisDate.getYear() + 1900;
   currentMonth = thisDate.getMonth();
   currentDate = thisDate.getDate();

   setWeek(currentYear, currentMonth, currentDate);
}

function handleDateSelected(selectedDate:String):Void
{
   trace("handleDate:" + selectedDate);
}

function init():Void 
{
   // Przygotowanie ekranu, za wyjątkiem przycisków, które zostaną utworzone odpowiednio
   // dla każdego tygodnia
   createButton("previousWeekButton", "<<", "", this, 30, 40, 20, 20,
   handlePreviousWeek);
   createButton("nextWeekButton", ">>", "", this, 270, 40, 20, 20, handleNextWeek);

   this.createTextField("day0Label", this.getNextHighestDepth(), 65, 25, 20, 20);
   this.day0Label.text = "N";
   this.createTextField("day1Label", this.getNextHighestDepth(), 95, 25, 20, 20);
   this.day1Label.text = "P";
   this.createTextField("day2Label", this.getNextHighestDepth(), 125, 25, 20, 20);
   this.day2Label.text = "W";
   this.createTextField("day3Label", this.getNextHighestDepth(), 155, 25, 20, 20);
   this.day3Label.text = "Ś";
   this.createTextField("day4Label", this.getNextHighestDepth(), 185, 25, 20, 20);
   this.day4Label.text = "C";
   this.createTextField("day5Label", this.getNextHighestDepth(), 215, 25, 20, 20);
   this.day5Label.text = "P";
   this.createTextField("day6Label", this.getNextHighestDepth(), 245, 25, 20, 20);
   this.day6Label.text = "S";

   this.createTextField("monthYearLabel", this.getNextHighestDepth(), 130, 5, 150,
   20);

   // Inicjowanie aktualnej daty. Dopasuj dzisiejszą datę tak, aby wskazywała
   // na ubiegłą niedzielę, co umożliwi wyrównanie nazw dni
   // z etykietami. Jeżeli aktualny dzień to np. Środa, metoda getDay()
   // zwróci liczbę 3. Odjęcie 3 od daty da sobotę.
   var todaysDate:Date = new Date ();
   todaysDate.setDate(todaysDate.getDate() - todaysDate.getDay());

   currentYear = todaysDate.getYear() + 1900; 
   currentMonth = todaysDate.getMonth();
   currentDate = todaysDate.getDate();

   setWeek(currentYear, currentMonth, currentDate);
}

init();
