﻿function drawRectangle(targetMC:MovieClip, rectWidth:Number, rectHeight:Number,
bgColor:Number):Void
{
   targetMC.moveTo(0, 0);
   targetMC.lineStyle(1, 0x000000) ;
   targetMC.beginFill(bgColor, 100);
   targetMC.lineTo(rectWidth, 0) ;
   targetMC.lineTo(rectWidth, rectHeight);
   targetMC.lineTo(0, rectHeight);
   targetMC.lineTo(0, 0);
}

function buttonClickHandler():Void
{
   trace("Naciśnięto przycisk");
}

function convertToButton(targetMC:MovieClip, callbackFunction:Function):Void
{
   drawRectangle(targetMC, 100, 30, 0x333399);

   targetMC.onPress = function()
   {
         this.clear();
         drawRectangle(this, 100, 30, 0xCC3333); 
    }

   targetMC.onRelease = function()
   {
      this.clear();
      drawRectangle(this, 100, 30, 0x6666AA);
      callbackFunction();
   }

   targetMC.onReleaseOutside = function()
   {
      this.clear();
      drawRectangle(this, 100, 30, 0x333399);
   }

   targetMC.onRollOver = function()
   {
      this.clear();
      drawRectangle(this, 100, 30, 0x6666AA);
   }

   targetMC.onRollOut = function()
   {
      this.clear();
      drawRectangle(this, 100, 30, 0x333399);
   }
}

this.createEmptyMovieClip("testButton", 1);
convertToButton(testButton, buttonClickHandler);
