﻿class StringLib
{
	private function StringLib ()
	{
		// W konstruktorze nie umieszczamy niczego.
	}
	public static function replace (sourceString:String, searchString:String, replaceString:String):String
	{
		var newString:String = sourceString.split (searchString).join (replaceString);
		return newString;
	}
	// Usuwanie rozpoczynających spacji tabulatorów lub początków wierszy.
	public static function trimWhiteSpace (sourceString:String):String
	{
		var numChars:Number = sourceString.length;
		var firstCharPosition:Number = 0;
		var lastCharPosition:Number = numChars - 1;
		var whiteSpaceChars:String = " \t\n\r";
		var currentChar:String;
		// Wyszukiwanie pierwszego znaku, który nie jest białym znakiem.
		for (var i = 0; i < numChars; i++)
		{
			currentChar = sourceString.charAt (i);
			if (whiteSpaceChars.indexOf (currentChar) == -1)
			{
				firstCharPosition = i;
				break;
			}
		}
		//Wyszukiwanie ostatniego znaku, który nie jest białym znakiem.
		for (i = numChars - 1; i >= 0; i--)
		{
			currentChar = sourceString.charAt (i);
			if (whiteSpaceChars.indexOf (currentChar) == -1)
			{
				lastCharPosition = i;
				break;
			}
		}
		return sourceString.slice (firstCharPosition, lastCharPosition + 1);
	}
	public static function countWords (sourceString:String):Number
	{
		var tempString:String = StringLib.trimWhiteSpace (sourceString);
		while (tempString.indexOf ("  ") >= 0)
		{
			// Zastępowanie podwójnych spacji pojedynczymi
			// w całym łańcuchu znaków, aż do momentu wyszukania wszystkich.
			tempString = StringLib.replace (tempString, "  ", " ");
		}
		// Konwertowanie na tablicę i dzielenie jej
		// za pomocą znaków spacji jako separatorów.
		var wordArray:Array = tempString.split (" ");
		// Długość tablicy odpowiada liczbie słów
		// oryginalnego łańcucha znaków.
		return wordArray.length;
	}
	public static function countSentences (sourceString:String):Number
	{
		// Wyszukiwanie kombinacji znaków ". " poprzez wyszukiwanie spacji poprzedzanych kropką,
		// liczby dziesiętne ani ostatnia kropka nie będą brane pod uwagę.
		var sentenceArray:Array = sourceString.split (". ");
		return sentenceArray.length;
	}
}
