﻿import mx.controls.Button;
import mx.controls.Label;
import mx.controls.TextInput;
import mx.controls.ProgressBar;
import flash.net.FileReference;

var eventHandler:Object = new Object();
var fileRefListener:Object = new Object();
var fileRef:FileReference = new FileReference();

setupInterface();

function setupInterface()
{
   this.createClassObject(Label, "urlLabel", this.getNextHighestDepth(), {_x:10, _y:13});
   urlLabel.text = "URL:";

   this.createClassObject(TextInput, "urlInput", this.getNextHighestDepth(), {_x:60, _y:10, _width:450});
   urlInput. text = "http://www.macromedia.com/platform/whitepapers/platform_overview.pdf";

   this.createClassObject(Button, "openWindowButton", this.getNextHighestDepth(), {_x:10, _y:50});
   openWindowButton.label = "Pobierz plik";
   openWindowButton.addEventListener("click", eventHandler);

   this.createClassObject(ProgressBar, "fileTransferProgressBar",
   this.getNextHighestDepth());
   fileTransferProgressBar._x = 120;
   fileTransferProgressBar._y = 50;
   fileTransferProgressBar.mode = "manual";
   fileTransferProgressBar.label = "Pobrano: %3%%";
   fileTransferProgressBar._visible = false;

   this.createTextField("feedbackField", this.getNextHighestDepth(), 10, 80, 400, 30); 
}

fileRefListener.onOpen = function(file:FileReference)
{
   feedbackField.text = "Rozpoczynam pobieranie pliku.";
   fileTransferProgressBar._visible = true;
}

fileRefListener.onProgress = function(file:FileReference, bytesLoaded:Number, bytesTotal:Number)
{
   feedbackField.text = "Trwa pobieranie";
   fileTransferProgressBar.setProgress(bytesLoaded, bytesTotal);
}

fileRefListener.onComplete = function(file:FileReference)
{
   feedbackField.text = "Pobieranie zakończone.";
   fileTransferProgressBar._visible = false;
}

fileRefListener.onIOError = function(file:FileReference)
{
   feedbackField.text = "Niepowodzenie pobierania — błąd dyskowy.";
   fileTransferProgressBar._visible = false;
}

fileRefListener.onSecurityError = function(file:FileReference)
{
   feedbackField.text = "Niepowodzenie pobierania – błąd zabezbieczeń lub brak dostępu.";
   fileTransferProgressBar._visible = false;
}

eventHandler.click = function()
{
   fileRef.addListener(fileRefListener);
   fileRef.download(urlInput.text);
}
