﻿import mx.controls.Button;
import mx.controls.ProgressBar;
import flash.net.FileReference;

var eventHandler:Object = new Object();
var fileRefListener:Object = new Object();
var fileRef:FileReference = new FileReference();

var fileTypes:Array = new Array();

var imageTypes:Object = new Object();
imageTypes.description = "Images (*.jpg, *.jpeg, *.gif, *.png)";
imageTypes.extension = "*.jpg; *.jpeg; *.gif; *.png";
fileTypes.push(imageTypes);

var htmlTypes:Object = new Object();
htmlTypes.description = "HTML (*.html, *.htm)";
htmlTypes.extension = "*.html; *.png";
fileTypes.push(htmlTypes);

setupInterface();

function setupInterface()
{
	this.createClassObject(Button, "openWindowButton", this.getNextHighestDepth(), {_x:10, _y:20});
	openWindowButton.label = "Upload";
	openWindowButton.addEventListener("click", eventHandler);

	this.createClassObject(ProgressBar, "fileTransferProgressBar", this.getNextHighestDepth());
	fileTransferProgressBar._x = 120;
	fileTransferProgressBar._y = 20;
	fileTransferProgressBar.mode = "manual";
	fileTransferProgressBar.label = "Uploaded %3%%";
	fileTransferProgressBar._visible = false;

	this.createTextField("feedbackField", this.getNextHighestDepth(), 10, 50, 400, 30);
}

fileRefListener.onSelect = function(file:FileReference)
{
	feedbackField.text = "File selected: " + file.name;
	file.upload("http://www.yourdomain.com/yourUploadHandlerScript.cfm")
}

fileRefListener.onOpen = function(file:FileReference)
{
	feedbackField.text = "Starting file upload.";
	fileTransferProgressBar._visible = true;
}

fileRefListener.onProgress = function(file:FileReference, bytesLoaded:Number, bytesTotal:Number)
{
	feedbackField.text = "Upload in progress.";
	fileTransferProgressBar.setProgress(bytesLoaded, bytesTotal);
}

fileRefListener.onComplete = function(file:FileReference)
{
	feedbackField.text = "Upload complete.";
	fileTransferProgressBar._visible = false;
}

fileRefListener.onHTTPError = function (file:FileReference)
{
	feedbackField.text = "Upload failed - network error.";
	fileTransferProgressBar._visible = false;
}

fileRefListener.onIOError = function (file:FileReference)
{
	feedbackField.text = "Upload failed - disk error.";
	fileTransferProgressBar._visible = false;
}

fileRefListener.onSecurityError = function (file:FileReference)
{
	feedbackField.text = "Upload failed - security/permissions error.";
	fileTransferProgressBar._visible = false;
}

eventHandler.click = function()
{
	fileRef.addListener(fileRefListener);
	fileRef.browse(fileTypes);
}