﻿import mx.controls.DataGrid;
import flash.external.ExternalInterface;

var g_clickFunction:String = "";

init();

function init() : Void
{
	// Create the data grid
	this.createClassObject(mx.controls.DataGrid, "gridInstance", this.getNextHighestDepth());
	gridInstance.setSize(550, 250);
	
	// Set up the change handler so that a JavaScript function is called when a row is clicked
	var clickHandlerObject:Object = new Object();
	clickHandlerObject.change = function(eventObject:Object)
	{
		ExternalInterface.call(g_clickFunction, eventObject.target.selectedItem.data);
	}
	gridInstance.addEventListener("change", clickHandlerObject);

	// Register the functions which can be called using JavaScript
	ExternalInterface.addCallback("setColumnLabels", null, setColumnLabels);
	ExternalInterface.addCallback("setColumnWidths", null, setColumnWidths);
	ExternalInterface.addCallback("addRow", null, addRow);
	ExternalInterface.addCallback("setClickHandler", null, setClickHandler);
	ExternalInterface.addCallback("reset", null, reset);
	
	// Advertise to the calling HTML that the component is ready
	ExternalInterface.call("componentReady", true);
}

function setColumnLabels(columnLabelArray:Array) : Void
{
	for (var i=0; i < columnLabelArray.length; i++)
	{
		gridInstance.addColumn("column" + i);
		gridInstance.getColumnAt(i).headerText = columnLabelArray[i];
	}
}

function setColumnWidths(columnWidthArray:Array) : Void
{
	for (var i=0; i < columnWidthArray.length; i++)
	{
		gridInstance.getColumnAt(i).width = columnWidthArray[i];
	}
}

function addRow() : Void
{
	var rowObject = new Object();
	for (var i=0; i < arguments.length; i++)
	{
		if (i < arguments.length - 1)
		{
			rowObject["column" + i] = arguments[i];
		}
		else
		{
			rowObject.data = arguments[i];
		}
	}
	gridInstance.addItem(rowObject);
}

function setClickHandler(functionName:String)
{
	g_clickFunction = functionName;
}

function reset() : Void
{
	gridInstance.dataProvider = new Array();
}


//setColumnLabels(["Column 1", "Column 2"]);
//setColumnWidths([150, 150]);
//addRow("value1", "");
//setClickHandler("foo");
