﻿import mx.transitions.Tween;
import mx.transitions.easing.*;

var tweenSequence:Array = new Array();
var currentTween:Number = 0;
var numCompletedTweens:Number = 0;

function addTween(stepNum:Number, tweenHandle:Tween):Void
{
	tweenHandle.stop();
	tweenHandle.onMotionFinished = callNextTween;
	if (tweenSequence[stepNum] == undefined)
	{
		tweenSequence[stepNum] = new Array();
	}
	tweenSequence[stepNum].push(tweenHandle);
}

function startTweenSequence():Void
{
	playTweenSequence(0);
}

function playTweenSequence(sequenceNum:Number):Void
{
	for (var i:Number=0; i < tweenSequence[sequenceNum].length; i++)
	{
		tweenSequence[sequenceNum][i].start();
	}
}

function stopTweenSequence():Void
{
	for (var i:Number=0; i < tweenSequence[currentTween].length; i++)
	{
		tweenSequence[currentTween][i].stop();
	}
}

function resumeTweenSequence():Void
{
	for (var i:Number=0; i < tweenSequence[currentTween].length; i++)
	{
		tweenSequence[currentTween][i].resume();
	}
}

function callNextTween():Void
{
	numCompletedTweens += 1;
	if (currentTween < tweenSequence.length - 1 && numCompletedTweens == tweenSequence[currentTween].length)
	{
		currentTween += 1
		numCompletedTweens = 0;
		playTweenSequence(currentTween);
	}
}

