﻿var pMaxSize:Number = 150;
var pCenterX:Number = 275;
var pCenterY:Number = 200;
var pNumTraces:Number = 20;
var pNumLayers:Number = 30;
var pCurrentLayer:Number = 0;
var pLineColour:Number;

var pPointDegree:Array = new Array();
var pPointDegreeChange:Array = new Array();
var pPointScale:Array = new Array();
var pPointScaleChange:Array = new Array();
var pPointX:Array = new Array();
var pPointY:Array = new Array();

var pBaseTimeline:MovieClip;
var pIntervalId:Number;

//-------------------------------------------------------------
//-------------------------------------------------------------
function init(baseTimeline:MovieClip):Void
{
	pBaseTimeline = baseTimeline;
	pBaseTimeline.createEmptyMovieClip("holder", 0);
	
	for (var j:Number = 0; j < pNumLayers; j++)
	{
		pBaseTimeline.createEmptyMovieClip("layer" + j, j+1);
		pBaseTimeline["layer" + j]._x = pCenterX;
		pBaseTimeline["layer" + j]._y = pCenterY;
	}
	
	initTraces();
	
	pBaseTimeline.holder.onEnterFrame = function()
	{
		moveSpheres();
	}
	
	pIntervalId = setInterval(this, "updateSeeds", 2000);

}

//-------------------------------------------------------------
//-------------------------------------------------------------
function initTraces()
{
	// Inicjalizuje kolejne punkty okręgu
	for (var i:Number = 0; i < pNumTraces; i++) 
	{
		pPointX[i] = 0;
		pPointY[i] = 0;
		pPointDegree[i] = (6.28318530718/pNumTraces) * i;
		pPointScale[i] = 50;
	}
	
	// aktualizuje losowe wartości sterujące kolejną sekwencją ruchu
	updateSeeds();
	
	// Kreśli odcinek dla następnego ruchu dla każdego punktu okręgu
	for (i = 0; i < pNumTraces; i++) 
	{
		plotLine(i);
	}
}

//-------------------------------------------------------------
//-------------------------------------------------------------
// Aktualizuje współrzędne x/y dla każdej kropki
function moveSpheres() 
{
	for (var i:Number = 0; i < pNumTraces; i++) 
	{
		pPointDegree[i] += pPointDegreeChange[i]; // Inkrementuje kąt wokół środka
		pPointScale[i] += pPointScaleChange[i]; // Inkrementuje skalowanie
		plotLine(i, true);
	}
	
	// Realizuje wygaszanie śladu. Alfa bieżącej warstwy wynosi 100%
	// każda kolejna warstwa jest coraz bardziej wygaszona
	pBaseTimeline["layer" + pCurrentLayer]._alpha = 100;
	pCurrentLayer = (pCurrentLayer + 1) % pNumLayers;
	for (var j:Number = 0; j < pNumLayers; j++) 
	{
		pBaseTimeline["layer" + ((pCurrentLayer + j)%pNumLayers)]._alpha = (j/pNumLayers)*100;
	}
	pBaseTimeline["layer" + pCurrentLayer].clear(); // Zeruje ostatnią warstwę wygaszoną do 0%
}

//-------------------------------------------------------------
//-------------------------------------------------------------
// Aktualizuje pozycję klipu kreślącego i kreśli ślad z poprzedniej pozycji
function plotLine(i:Number, drawLine:Boolean) 
{
	pBaseTimeline["layer" + pCurrentLayer].lineStyle(1, pLineColour, 100);
	pBaseTimeline["layer" + pCurrentLayer].moveTo(pPointX[i], pPointY[i]);
	// współrzędne x/y są obliczane na podstawie kąta i skali dla każdego punktu 
	pPointX[i] = (Math.cos(pPointDegree[i]) * pPointScale[i]); 
	pPointY[i] = (Math.sin(pPointDegree[i]) * pPointScale[i]);
	if (drawLine == true) 
	{
		pBaseTimeline["layer" + pCurrentLayer].lineTo(pPointX[i], pPointY[i]);
	}
}

//-------------------------------------------------------------
//-------------------------------------------------------------
// Aktualizuje wartości losowe
function updateSeeds() 
{
	var deg:Number;
	var scale:Number;
	
	// Tworzy zakres kątów obejmujący jednorodnie wszystkie punkty
	deg = randomRange(-100, 100) / 2000;
	
	// Tworzy zakres skal obejmujący jednorodnie wszystkie punkty
	if (pPointScale[0] > pMaxSize) 
	{
		scale = randomRange(-10, 0) / 2;
	}
	else if (pPointScale[0] < -pMaxSize) 
	{
		scale = randomRange(0, 10) / 2;
	}
	else 
	{
		scale = randomRange(-10, 10) / 2;
	}
	
	// Przypisuje każdemu punktowi skalę i kąt
	for (var i:Number = 0; i < pNumTraces; i++) 
	{
		pPointDegreeChange[i] = deg;
		pPointScaleChange[i] = scale;
	}
	pLineColour = randomRange(0, 0xFFFFFF);
}

//-------------------------------------------------------------
//-------------------------------------------------------------
// Losuje liczbę całkowitą z zakresu od min do max
function randomRange(min:Number, max:Number):Number 
{
	var randomNum:Number = Math.round(Math.random()*(max-min))+min;
	return randomNum;
}

init(this);
