﻿var imageListListener:Object = new Object();
imageListListener.change = function(eventObject:Object)
{
   loadImage(eventObject.target.selectedItem.data);
}

var zoomListener:Object = new Object();
zoomListener.change = function(eventObject:Object)
{
   setZoom(eventObject.target.value);
}

var imageViewerListener:Object = new Object();
imageViewerListener.progress = function(eventObject:Object)
{
   var bytesLoaded:Number = eventObject.target.getBytesLoaded();
   var bytesTotal:Number = eventObject.target.getBytesTotal();
   trace("Załadowano: " + bytesLoaded + "/" + bytesTotal);
   if(bytesLoaded == -1)
   {
      loadImageError();
   }
   else
   {
      imageViewerProgress.setProgress(bytesLoaded, bytesTotal);
   }
}

imageViewerListener.complete = function(eventObject:Object)
{
   trace("Podgląd dostępny");
   imageViewerProgress._visible = false;
   setZoom(zoomStepper.value);
}

function init():Void
{
   // Przesyłanie danych do komponentu List.
   var imageArray:Array = new Array();
   imageArray.push({data:"images/aStudyInTexture.jpg", label:"A Study In Texture"});
   imageArray.push({data:"images/buntzenWinter.jpg", label:"Buntzen Winter"});
   imageArray.push({data:"images/flowerInDetail.jpg", label:"Flower In Detail"});
   imageArray.push({data:"images/galianoSunset.jpg", label:"Galiano Sunset"});
   imageList.dataProvider = imageArray;
   imageList.addEventListener("change", imageListListener);

   // Przygotowanie komponentu ProgressBar.
   imageViewerProgress.mode = "manual";
    imageViewerProgress._visible = false;

   // Przygotowanie komponentu ScrollPane.
   imageViewerPane.scrollDrag = true;
   imageViewerPane.addEventListener("progress", imageViewerListener);
   imageViewerPane.addEventListener("complete", imageViewerListener);

   // Przygotowanie komponentu NumericStepper.
   zoomStepper.maximum = 400;
   zoomStepper.minimum = 25;
   zoomStepper.stepSize = 25;
   zoomStepper.value = 100;
   zoomStepper.addEventListener("change", zoomListener);
}

function loadImage(imagePath:String):Void
{
   trace("ładowanie pliku: " + imagePath);
   if (imagePath != " " && imagePath != undefined)
   {
      imageViewerPane.contentPath = "";
      imageViewerPane.contentPath = imagePath;
      imageViewerProgress._visible = true;
      imageViewerProgress.setProgress(0, 100);

      clearInterval(intervalID);
      intervalID = setInterval(checkProgress, 200);
   }
}

function loadImageError():Void
{
   imageViewerProgress._visible = false;
   imageList.selectedIndex = null;
   imageViewerPane.contentPath = "";
}

function setZoom(zoomValue:Number): Void
{
   imageViewerPane.content._xscale = zoomValue;
   imageViewerPane.content._yscale = zoomValue;
   imageViewerPane.invalidate();
}

init();
